% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sharamov.R
\name{addBingTiles}
\alias{addBingTiles}
\title{Adds Bing Tiles Layer}
\usage{
addBingTiles(
  map,
  apikey = Sys.getenv("BING_MAPS_API_KEY"),
  imagerySet = c("Aerial", "AerialWithLabels", "AerialWithLabelsOnDemand",
    "AerialWithLabelsOnDemand", "Birdseye", "BirdseyeWithLabels", "BirdseyeV2",
    "BirdseyeV2WithLabels", "CanvasDark", "CanvasLight", "CanvasGray", "Road",
    "RoadOnDemand", "Streetside"),
  layerId = NULL,
  group = NULL,
  ...
)
}
\arguments{
\item{map}{The Map widget}

\item{apikey}{String. Bing API Key}

\item{imagerySet}{String. Type of Tiles to display}

\item{layerId}{String. An optional unique ID for the layer}

\item{group}{String. An optional group name for the layer}

\item{...}{Optional Parameters required by the Bing API described at
\url{https://learn.microsoft.com/en-us/bingmaps/getting-started/bing-maps-dev-center-help/getting-a-bing-maps-key?redirectedfrom=MSDN}}
}
\description{
Adds Bing Tiles Layer
}
\seealso{
Get a Bing Maps API Key: \url{https://learn.microsoft.com/en-us/bingmaps/rest-services/imagery/get-imagery-metadata?redirectedfrom=MSDN}
}
