% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metricsInternal.R
\name{defineInternalMetric}
\alias{defineInternalMetric}
\title{Define an internal metric for lcModels}
\usage{
defineInternalMetric(
  name,
  fun,
  warnIfExists = getOption("latrend.warnMetricOverride", TRUE)
)
}
\arguments{
\item{name}{The name of the metric.}

\item{fun}{The function to compute the metric, accepting a lcModel object as input.}

\item{warnIfExists}{Whether to output a warning when the metric is already defined.}
}
\description{
Define an internal metric for lcModels
}
\examples{
defineInternalMetric("BIC", fun = BIC)

mae <- function(object) {
  mean(abs(residuals(object)))
}
defineInternalMetric("MAE", fun = mae)
}
\seealso{
Other metric functions: 
\code{\link{defineExternalMetric}()},
\code{\link{externalMetric}()},
\code{\link{getExternalMetricDefinition}()},
\code{\link{getExternalMetricNames}()},
\code{\link{getInternalMetricDefinition}()},
\code{\link{getInternalMetricNames}()},
\code{\link{metric}()}
}
\concept{metric functions}
