% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stocks.R
\name{splot_summary}
\alias{splot_summary}
\alias{splot_change}
\alias{splot_growth}
\alias{splot_divs}
\alias{splot_roi}
\alias{splot_types}
\alias{splot_etf}
\title{Investing Portfolio Reporting Plots}
\usage{
splot_summary(p, s, save = FALSE)

splot_change(
  p,
  s,
  rel = TRUE,
  group = FALSE,
  n_days = 365,
  keep_old = FALSE,
  save = FALSE
)

splot_growth(p, save = FALSE)

splot_divs(p, type = 1)

splot_roi(p, n_days = 365, historical = TRUE, ma = c(12, 50), save = FALSE)

splot_types(s, save = FALSE)

splot_etf(s, keep_all = FALSE, cache = TRUE, save = FALSE)
}
\arguments{
\item{p}{Dataframe. Result from \code{daily_portfolio()}}

\item{s}{Dataframe. Result from \code{daily_stocks()}}

\item{save}{Boolean. Save plot into a local file?}

\item{rel}{Boolean. Relative delta values (weighted with portfolio)?
If not, absolute monetary delta values.}

\item{group}{Boolean. Group stocks by stocks type?}

\item{n_days}{Integer. How many days back you want to see?}

\item{keep_old}{Boolean. Include sold tickers even though not currently in portfolio?}

\item{type}{Integer. Typo of plot. 1 for incomes.}

\item{historical}{Boolean. Historical ROI metric? If not, ROI
will be calculated locally for n_days parameter}

\item{ma}{Numeric Vector. Select 2 values for moving averages.
Set to NA to turn this metric off}

\item{keep_all}{Boolean. Keep "Not Known / Not ETF"?}

\item{cache}{Boolean. Use daily cache if available?}
}
\value{
ggplot object
}
\description{
\code{splot_summary()} plots a summary for the whole portfolio, showing
how much have you invested, how much has each ticker changed, etc.

\code{splot_change()} plots each stock's change through history, since
inception, with weighted attributions or absolute values.

\code{splot_growth()} plots your portfolio's growth, in cash and investment,
since inception.

\code{stocks_plots()} plots a portfolio's historical dividends incomes
grouped by quarter an year.

\code{splot_roi()} plots a portfolio's historical ROI since inception
or since last n days, with 2 moving average lines.

\code{splot_types()} lets the user plot types or categories of tickers.

\code{splot_etf()} lets the user plot his portfolio's distribution,
specifically ETF's sectors.
}
\seealso{
Other Investment: 
\code{\link{etf_sector}()},
\code{\link{stocks_file}()},
\code{\link{stocks_quote}()}

Other Scrapper: 
\code{\link{filesGD}()},
\code{\link{get_mp3}()},
\code{\link{gtrends_related}()},
\code{\link{holidays}()},
\code{\link{ip_data}()},
\code{\link{readGS}()},
\code{\link{stocks_quote}()}
}
\concept{Investment}
\concept{Scrapper}
