% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{setDispersalHost}
\alias{setDispersalHost}
\title{Set host dispersal}
\usage{
setDispersalHost(params, mat)
}
\arguments{
\item{params}{a LandsepiParams Object.}

\item{mat}{a square matrix giving the probability of host dispersal
from any polygon of the landscape to any other polygon.
It can be generated manually, or, alternatively, via \code{\link{loadDispersalHost}}.
The size of the matrix must match the number of polygons in the landscape.}
}
\value{
a LandsepiParam object.
}
\description{
Updates a LandsepiParams object with a host dispersal matrix.
Note that landscape parameters must be set before updating setting dispersal.
}
\details{
the dispersal matrix gives the probability for a host individual in a polygon i (row)
to migrate to polygon j (column) through dispersal.
If the host is a cultivated plant: seeds are harvested and do not disperse.
Thus the dispersal matrix is the identity matrix.
}
\examples{
\dontrun{
simul_params <- createSimulParams()
simul_params <- setLandscape(simul_params, loadLandscape(1))
d <- loadDispersalHost(simul_params)
simul_params <- setDispersalHost(simul_params, d)
simul_params@DispHost
}
}
\seealso{
\link{loadDispersalHost}
}
