% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplexImport.R
\name{simplexImport}
\alias{simplexImport}
\title{Imports the information contained in a \code{.smplx} file.}
\usage{
simplexImport(filename, aut.load = TRUE, name = NULL)
}
\arguments{
\item{filename}{string with the name of the file (without extension) to
be imported. This file must be generated using
\code{\link{simplexExport}}. The path must be included if
the file is not in the current working directory.}

\item{aut.load}{logical. Should the imported simplex object be directly
loaded on the Environment? Default to TRUE.}

\item{name}{name for the simplex object to be created if
\code{auth.ld = FALSE}. When not provided, the name of the
file is used.}
}
\value{
A \code{smplx} class object with the complete information of the
        simplex
}
\description{
The function reads and (optionally) loads into the environment the simplex
(object of class \code{smplx}) contained in a \code{.smplx} file that was
previously created using \code{\link{simplexExport}}.
}
\examples{
  \donttest{
  simplexR2 <- exampleOptimization(surface = exampleSurfaceR2)
  simplexExport(simplex = simplexR2)
  rm(simplexR2)
  simplexImport(filename = "simplexR2")
  }
}
\seealso{
\code{\link{simplexImport}}
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Jesús Ágreda, \email{jagreda@unal.edu.co}
}
