% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l1ball.R
\name{l1ball}
\alias{l1ball}
\title{Fit the L1 prior}
\arguments{
\item{y}{A data vector, n by 1}

\item{X}{A design matrix, n by p}

\item{b_w}{The parameter in \eqn{Beta(1, p^{b_w})} for \eqn{w}, default \eqn{b_w=1}}

\item{step}{Number of steps to run the Markov Chain Monte Carlo}

\item{burnin}{Number of burn-ins}

\item{b_lam}{The parameter in \eqn{\lambda_i \sim Inverse-Gamma(1, b_\lambda)}, default \eqn{b_\lambda=10^{-3}}. To increase the level of shrinkage, use smaller \eqn{b_\lambda}.}
}
\value{
The posterior sample collected from the Markov Chain:\itemize{
\item trace_theta: \eqn{\theta}
\item trace_NonZero: The non-zero indicator \eqn{1(\theta_i\neq 0)}
\item trace_Lam: \eqn{\lambda_i}
\item trace_Sigma: \eqn{\sigma^2}
}
}
\description{
This package provides an implementation of the Gibbs sampler, for using l1-ball prior with the regression likelihood  \eqn{y_i = X_i\theta+ \epsilon_i, \epsilon_i\sim {N}(0,\sigma^2)}.
}
\examples{
n = 60
p = 100
X <- matrix(rnorm(n*p),n,p)
d = 5
w0 <- c(rep(0, p-d), rnorm(d)*0.1+1)
y = X\%*\% w0 + rnorm(n,0,.1)
trace <- l1ball(y,X,steps=2000,burnin = 2000)
plot(colMeans(trace$trace_theta))
}
