# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Distance Matrix Computation
#'
#' Computes and returns the distance matrix using euclidean distance
#' measure to compute the distances between the rows of a
#' data matrix.
#'
#' @param x a numeric matrix.
#'
#' @return
#' A numeric matrix with the distances between the rows of a matrix.
#'
.distance <- function(x) {
    .Call('_ktaucenters_distance', PACKAGE = 'ktaucenters', x)
}

#' Robust Clustering algorithm based on centers, a robust and efficient version
#' of kmeans.
#'
#' @param x numeric matrix of size n x p with all observations.
#' @param centers numeric matrix with initial cluster centers.
#' @param tolerance maximum difference between current and new computed
#' clusters. Parameter used for the algorithm stopping rule.
#' @param max_iter a maximum number of iterations used for the algorithm
#' stopping rule.
#'
#' @return A list with the following components:
#' \item{tau }{\eqn{\tau} scale value. }
#' \item{iter }{number of iterations until convergence is achieved or maximum
#' number of iteration is reached. }
#' \item{di }{distance of each observation to its nearest cluster center. }
#' \item{centers }{numeric matrix of size K x p, with the estimated K centers.
#'  }
#' \item{clusters }{integer vector of size n with the cluster location for each
#' observation. }
#'
#'@references
#' [1] Gonzalez, J. D., Yohai, V. J., & Zamar, R. H. (2019).
#' Robust Clustering Using Tau-Scales. arXiv preprint arXiv:1906.08198.
#'
#' [2] Maronna, R. A. and Yohai, V. J. (2017). Robust and efficient estimation
#' of multivariate scatter and location.Computational Statistics &Data
#' Analysis, 109 : 64–75.
#'
.ktaucenters_run <- function(x, centers, tolerance, max_iter) {
    .Call('_ktaucenters_ktaucenters_run', PACKAGE = 'ktaucenters', x, centers, tolerance, max_iter)
}

#' Flag outliers
#'
#' @param cutoff quantile of chi-square to be used as a threshold for outliers
#' detection.
#' @param b break down point.
#' @param ktau ktaucenters results.
#'
#' @return
#' Numeric vector with the weight factor for each observation
#'
.flag_outliers <- function(cutoff, b, ktau) {
    .Call('_ktaucenters_flag_outliers', PACKAGE = 'ktaucenters', cutoff, b, ktau)
}

#' Quasi optimal \eqn{\rho} function
#'
#' @param x numeric vector with positive values.
#' @param cc tunning constant.
#'
#' @return
#' Numeric vector with quasi optimal \eqn{\rho} computation for each element
#' of x.
#'
#'@references
#' [1] Salibian-Barrera, M., Willems, G., & Zamar, R. (2008). The fast-tau
#' estimator for regression. Journal of Computational and GraphicalStatistics,
#' 17(3), 659-682.
#'
#'@export
rhoOpt <- function(x, cc) {
    .Call('_ktaucenters_rhoOpt', PACKAGE = 'ktaucenters', x, cc)
}

#' Derivative of the quasi optimal \eqn{\rho} function
#'
#' @param x numeric vector with positive values.
#' @param cc tunning constant.
#'
#' @return
#' Numeric vector with the derivative of the quasi optimal \eqn{\rho}
#' computation for each element of x.
#'
#'@export
psiOpt <- function(x, cc) {
    .Call('_ktaucenters_psiOpt', PACKAGE = 'ktaucenters', x, cc)
}

#' Second derivative of the quasi \eqn{\rho} function
#'
#' @param x numeric vector with positive values.
#' @param cc tunning constant.
#'
#' @return
#' Numeric vector with the second derivative of the quasi optimal \eqn{\rho}
#' computation for each element of x.
#'
#'@export
derpsiOpt <- function(x, cc) {
    .Call('_ktaucenters_derpsiOpt', PACKAGE = 'ktaucenters', x, cc)
}

#' Robust Initialization based on Inverse Density estimator (ROBINDEN)
#'
#' Searches for k initial cluster seeds for k-means based clustering methods.
#'
#' @param D a distance matrix, which contains the distances between the rows of
#' a matrix.
#' @param n_clusters number of cluster centers to find.
#' @param mp number of nearest neighbors to compute point density.
#'
#' @return A list with the following components:
#' \item{\code{centers}}{: A numeric vector with the initial cluster centers
#' indices.}
#' \item{\code{idpoints}}{: A real vector containing the inverse of point
#' density estimation.}
#'
#' @details
#' The centers are the observations located in the most dense region
#' and far away from each other at the same time.
#' In order to find the observations in the highly dense region, this function
#' uses point density estimation (instead of Local Outlier Factor, Breunig et
#' al (2000)), see more details.
#'
#' @note This is a slightly modified version of ROBIN algorithm
#' implementation done by Sarka Brodinova <sarka.brodinova@tuwien.ac.at>.
#' @author Juan Domingo Gonzalez <juanrst@hotmail.com>
#'
#' @examples
#' # Generate synthetic data (7 cluster well separated)
#' K <- 5
#' nk <- 100
#' Z <- rnorm(2 * K * nk)
#' mues <- rep(5 * -floor(K/2):floor(K/2), 2 * nk * K)
#' X <-  matrix(Z + mues, ncol = 2)
#'
#' # Generate synthetic outliers (contamination level 20%)
#' X[sample(1:(nk * K), (nk * K) * 0.2), ] <-
#'   matrix(runif((nk * K) * 0.2 * 2, 3 * min(X), 3 * max(X)),
#'          ncol = 2,
#'          nrow = (nk * K)* 0.2)
#' res <- robinden(D = as.matrix(dist(X)), n_clusters = K, mp = 10);
#' # plot the Initial centers found
#' plot(X)
#' points(X[res$centers, ], pch = 19, col = 4, cex = 2)
#'
#' @references Hasan AM, et al. Robust partitional clustering by
#' outlier and density insensitive seeding. Pattern Recognition Letters,
#' 30(11), 994-1002, 2009.
#'
#'@export
robinden <- function(D, n_clusters, mp) {
    .Call('_ktaucenters_robinden', PACKAGE = 'ktaucenters', D, n_clusters, mp)
}

#' Normal Consistency Constants
#'
#' M scale tuning constants so it is consistent with the standard
#' normal distribution for the quasi optimal \eqn{\rho} function used in
#' \code{\link{rhoOpt}}. These constants were computed for 1 \eqn{\leq} p
#' \eqn{\leq} 400.
#'
#' @param p dimension where observation lives.
#'
#' @return tuning constant.
#'
#' @references
#' [1] Maronna, R. A., Martin, R. D., Yohai, V. J., & Salibián-Barrera, M.
#' (2018). 'Robust statistics: theory and methods (with ' R). Wiley.
#'
#' [2] Salibian-Barrera, M., Willems, G., & Zamar, R. (2008). The fast-tau
#' estimator for regression. 'Journal of Computational and Graphical
#' Statistics, 17(3), 659-682.
#'
#'@export
normal_consistency_constants <- function(p) {
    .Call('_ktaucenters_normal_consistency_constants', PACKAGE = 'ktaucenters', p)
}

#' M scale
#'
#' The M scale of an univariate sample.
#'
#' @param u numeric vector with positive values.
#' @param c a tuning constant. If consistency to standard normal distribution
#' is desired use \code{\link{normal_consistency_constants}}.
#' @param b the desired break down point.
#'
#' @return
#' M scale value.
#'
#' @examples
#' Mscale(u = rnorm(100), c = 1, b = 0.5)
#'
#' @references Maronna, R. A., Martin, R. D., Yohai, V. J., & Salibian-Barrera,
#' M. (2018). Robust statistics: theory and methods (with R). Wiley.
#'
#'@export
Mscale <- function(u, c, b) {
    .Call('_ktaucenters_Mscale', PACKAGE = 'ktaucenters', u, c, b)
}

