% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmbasis.R, R/kmbasis.kmsurmisefunction.R,
%   R/kmbasis.kmsurmiserelation.R, R/kmbasis.matrix.R
\name{kmbasis}
\alias{kmbasis}
\alias{kmbasis.kmsurmisefunction}
\alias{kmbasis.kmsurmiserelation}
\alias{kmbasis.matrix}
\title{Compute the basis of a knowledge space}
\usage{
kmbasis(x)

\method{kmbasis}{kmsurmisefunction}(x)

\method{kmbasis}{kmsurmiserelation}(x)

\method{kmbasis}{matrix}(x)
}
\arguments{
\item{x}{Binary matrix representing a knowledge space}
}
\value{
Binary matrix representing the basis of the knowledge space.

Basis

Basis

Binary matrix representing the basis of the knowledge space.
}
\description{
\code{kmbasis.matrix} returns a matrix representing the basis of a
knowledge space. If \code{x} is a knowledge structure or an
arbitrary family of sets \code{kmbasis} returns the basis of
the smallest knowledge space containing \code{x}.

\code{kmbasis.kmsurmiserelation} takes a surmise relation and returns the
corresponding basis.

\code{kmbasis.matrix} returns a matrix representing the basis of a
knowledge space. If \code{x} is a knowledge structure or an
arbitrary family of sets \code{kmbasis} returns the basis of
the smallest knowledge space containing \code{x}.
}
\examples{
kmbasis(xpl$space)

kmbasis(xpl$space)

}
\seealso{
Other Different representations for knowledge spaces: 
\code{\link{kmSF2basis}()},
\code{\link{kmSR2basis}()},
\code{\link{kmsurmisefunction}()},
\code{\link{kmsurmiserelation}()},
\code{\link{kmunionclosure}()}

Other Different representations for knowledge spaces: 
\code{\link{kmSF2basis}()},
\code{\link{kmSR2basis}()},
\code{\link{kmsurmisefunction}()},
\code{\link{kmsurmiserelation}()},
\code{\link{kmunionclosure}()}

Other Different representations for knowledge spaces: 
\code{\link{kmSF2basis}()},
\code{\link{kmSR2basis}()},
\code{\link{kmsurmisefunction}()},
\code{\link{kmsurmiserelation}()},
\code{\link{kmunionclosure}()}

Other Different representations for knowledge spaces: 
\code{\link{kmSF2basis}()},
\code{\link{kmSR2basis}()},
\code{\link{kmsurmisefunction}()},
\code{\link{kmsurmiserelation}()},
\code{\link{kmunionclosure}()}
}
\concept{Different representations for knowledge spaces}
