% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_plot.kRp.text.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,kRp.text,missing-method}
\title{Plot method for objects of class kRp.text}
\usage{
plot(x, y, ...)

\S4method{plot}{kRp.text,missing}(x, what = "wclass", ...)
}
\arguments{
\item{x}{An object of class \code{kRp.text}}

\item{y}{From the generic \code{plot} function, ignored for koRpus class objects.}

\item{...}{Any other argument suitable for plot()}

\item{what}{Character string, valid options are:
\describe{
  \item{\code{"wclass"}:}{Barplot of distribution of word classes}
  \item{\code{"letters"}:}{Line plot of distribution of word length in letters}
}}
}
\description{
Plot method for S4 objects of class \code{\link[koRpus:kRp.text-class]{kRp.text}},
plots the frequencies of tagged word classes.
}
\examples{
# code is only run when the english language package can be loaded
if(require("koRpus.lang.en", quietly = TRUE)){
  sample_file <- file.path(
    path.package("koRpus"), "examples", "corpus", "Reality_Winner.txt"
  )
  tokenized.obj <- tokenize(
    txt=sample_file,
    lang="en"
  )
  plot(tokenized.obj)
} else {}
}
\seealso{
\code{\link[koRpus:kRp.text-class]{kRp.text}}
}
\keyword{methods}
\keyword{plot}
