% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_docTermMatrix.R
\docType{methods}
\name{docTermMatrix}
\alias{docTermMatrix}
\alias{docTermMatrix,data.frame-method}
\alias{docTermMatrix,-methods}
\alias{docTermMatrix,kRp.text-method}
\title{Generate a document-term matrix}
\usage{
docTermMatrix(obj, terms = "token", case.sens = FALSE, tfidf = FALSE, ...)

\S4method{docTermMatrix}{data.frame}(obj, terms = "token", case.sens = FALSE,
      tfidf = FALSE)

\S4method{docTermMatrix}{kRp.text}(obj, terms = "token", case.sens = FALSE, tfidf = FALSE)
}
\arguments{
\item{obj}{Either an object of class \code{\link[koRpus:kRp.text-class]{kRp.text}},
      or a TIF[1] compliant token data frame.}

\item{terms}{A character string defining the \code{tokens} column to be used for calculating the matrix.}

\item{case.sens}{Logical, whether terms should be counted case sensitive.}

\item{tfidf}{Logical,
      if \code{TRUE} calculates term frequency--inverse document frequency (tf-idf)
values instead of absolute frequency.}

\item{...}{Additional arguments depending on the particular method.}
}
\value{
A sparse matrix of class \code{\link[Matrix:dgCMatrix-class]{dgCMatrix}}.
}
\description{
Returns a sparse document-term matrix calculated from a given TIF[1] compliant token data frame
or object of class \code{\link[koRpus:kRp.text-class]{kRp.text}}. You can also
calculate the term frequency inverted document frequency value (tf-idf) for each term.
}
\details{
This is usually more interesting if done with more than one single text. If you're interested
in full corpus analysis, the \code{tm.plugin.koRpus} package should be worth checking out.
Alternatively, a data frame with multiple \code{doc_id} entries can be used.

See the examples to learn how to limit the analysis to desired word classes.
}
\examples{
# code is only run when the english language package can be loaded
if(require("koRpus.lang.en", quietly = TRUE)){
  sample_file <- file.path(
    path.package("koRpus"), "examples", "corpus", "Reality_Winner.txt"
  )
  # of course this makes more sense with a corpus of
  # multiple texts, see the tm.plugin.koRpus[2] package
  # for that
  tokenized.obj <- tokenize(
    txt=sample_file,
    lang="en"
  )
  # get the document-term frequencies in a sparse matrix
  myDTMatrix <- docTermMatrix(tokenized.obj)

  # combine with filterByClass() to, e.g.,  exclude all punctuation
  myDTMatrix <- docTermMatrix(filterByClass(tokenized.obj))

  # instead of absolute frequencies, get the tf-idf values
  myDTMatrix <- docTermMatrix(
    filterByClass(tokenized.obj),
    tfidf=TRUE
  )
} else {}
}
\references{
[1] Text Interchange Formats (\url{https://github.com/ropensci/tif})
   [2] tm.plugin.koRpus: https://CRAN.R-project.org/package=tm.plugin.koRpus
}
