% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadGenome.R
\name{loadGenome}
\alias{loadGenome}
\title{Build Genome object.}
\usage{
loadGenome(
  genome.name,
  fasta.style,
  mask = "none",
  fasta.path,
  ncbi.db,
  ncbi.asm,
  use.UCSC.name = FALSE,
  load.limit = 1
)
}
\arguments{
\item{genome.name}{A genome name. UCSC and NCBI genome is included with
kmeRtone. Input their name e.g. hg19 or GRCh37.}

\item{fasta.style}{FASTA version: "UCSC" or "NCBI".}

\item{mask}{Genome mask: "none", "soft", or "hard". Default is "none".}

\item{fasta.path}{Path to a directory of user-provided genome FASTA files or
the destination to save the NCBI/UCSC downloaded reference genome files.}

\item{ncbi.db}{NCBI database: "refseq" or "genbank".}

\item{ncbi.asm}{NCBI assembly table.}

\item{use.UCSC.name}{For NCBI Genome, use UCSC-style chromosome name? Default
is FALSE.}

\item{load.limit}{Maximum chromosome sequences loaded. Default is 1.}
}
\value{
A \code{UCSC_Genome} or \code{NCBI_Genome} object.
}
\description{
The Genome object is capable of loading chromosome sequence on demand.
UCSC Genomes are included in this kmeRtone package. Their specific
chromosome sequence will be downloaded on demand once.
}
