% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/klsh.R
\name{rproject_bags}
\alias{rproject_bags}
\title{Function that generates unit random vectors and 
takes (weighted) projections onto the random unit vectors given a bag of words}
\usage{
rproject_bags(sack_of_bags, weighting_table)
}
\arguments{
\item{sack_of_bags}{Sack of bag of words}

\item{weighting_table}{Weighting table (inverse document frequency)}
}
\value{
Computes the inverse document frequency for a bag of words
}
\description{
Function that generates unit random vectors and 
takes (weighted) projections onto the random unit vectors given a bag of words
}
\examples{
data(RLdata500)
data.500 <- RLdata500[-c(2,4)]
sack <- sacks_of_bags_of_words(data.500[1:3,c(-2)],k=2)
idf <- calc_idf(sack)
match(names(sack[[1]]), names(idf))
rproject_bags(sack, idf)
}
