% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pc_cor_plot.R
\name{pc_cor_plot}
\alias{pc_cor_plot}
\title{Principal Component Correlation Plot}
\usage{
pc_cor_plot(data, PC_1, PC_2, text_col = "red")
}
\arguments{
\item{data}{A dataset of class data.frame. The data should contain 'C_X' and 'C_Y' columns
representing the x and y coordinates of the data points and excludes any rank,
ID, or column not for analysis, see README for details}

\item{PC_1}{A string specifying the first PC for comparison, can be chosen from "PC1" to "PC10". For example, "PC1".}

\item{PC_2}{A string specifying the second PC for comparison, can be chosen from "PC1" to "PC10". For example, "PC2".}

\item{text_col}{An R color for the text labels. Defaults to "red".}
}
\value{
A ggplot object representing the correlation plot.
}
\description{
This function generates a correlation plot, also known as a "circle" plot, which compares the loadings from one principal component (PC) against another.
It visualizes the similarity among original variables and their correlation with each PC, revealing potential clusters. The function also adds annotations for understanding positive and negative values in different quadrants.
}
\examples{
data("Klovan_Row80")
pc_cor_plot(Klovan_Row80, "PC1", "PC2")

}
