% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_score_plot.R
\name{factor_score_plot}
\alias{factor_score_plot}
\title{Map the Factor Scores}
\usage{
factor_score_plot(
  Interp_Data,
  overlay,
  data,
  FA_colors = c(FA1 = "black", FA2 = "blue", FA3 = "darkred", FA4 = "green", FA5 =
    "purple", FA6 = "orange", FA7 = "yellow", FA8 = "pink", FA9 = "cyan", FA10 =
    "magenta")
)
}
\arguments{
\item{Interp_Data}{A plottable data frame produced by the \code{inv_dis_wt()} or \code{kriging()} functions.}

\item{overlay}{A Boolean input. If TRUE, the plot will overlay isolines; if FALSE, it will not.}

\item{data}{a klovan dataset (transformed, untransformed, outlier, etc), see README for details.}

\item{FA_colors}{A named vector of colors for different factors. Defaults
to a set color palette.}
}
\value{
A ggplot object representing the Factor Scores plot.
}
\description{
This function creates a faceted plot of each rotated factor score,
which could be interpreted as the elements of a "phantom" variable.
This function aids in defining the relationship between the phantom variables
and the known ore body by producing a contoured map for each variable.
}
\examples{
\donttest{
data("Klovan_Row80")
factor_plot1 <- factor_score_plot(inv_dis_wt(Klovan_Row80), TRUE, data = Klovan_Row80)
factor_plot1

your_interp_data_IDW <- inv_dis_wt(Klovan_Row80, 3)
factor_score_plot(your_interp_data_IDW, FALSE, data = Klovan_Row80)
}

}
