% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk_tune.R
\name{rk_tune}
\alias{rk_tune}
\title{tune random feature number for KKO.}
\usage{
rk_tune(
  X,
  y,
  X_k,
  rfn_range,
  n_stb,
  cv_folds,
  frac_stb = 1/2,
  nCores_para = 1,
  rkernel = "laplacian",
  rk_scale = 1
)
}
\arguments{
\item{X}{design matrix of additive model; rows are observations and columns are variables.}

\item{y}{response of addtive model.}

\item{X_k}{knockoffs matrix of design; the same size as X.}

\item{rfn_range}{a vector of random feature expansion numbers to be tuned.}

\item{n_stb}{number of subsampling in KKO.}

\item{cv_folds}{the folds of cross-validation for tuning group lasso.}

\item{frac_stb}{fraction of subsample.}

\item{nCores_para}{number of cores for parallelizing subsampling.}

\item{rkernel}{kernel choices. Default is "laplacian". Other choices are "cauchy" and "gaussian".}

\item{rk_scale}{scaling parameter of sampling distribution for random feature expansion. For gaussian kernel, it is standard deviation of gaussian sampling distribution.}
}
\value{
a list of tuning results.
\tabular{ll}{
\code{rfn_tune}  \tab  tuned optimal random feature number.  \cr
\code{rfn_range}  \tab a vector of random feature expansion numbers to be tuned. \cr
\code{scores} \tab scores of random feature numbers. rfn_tune has the maximal score. \cr
\code{Pi_list} \tab a list of subsample selection results for each random feature number. \cr
}
}
\description{
The function applys KKO with different random feature numbers to tune the optimal number.
}
\examples{
library(knockoff)
p=5 # number of predictors
sig_mag=100 # signal strength
n= 100 # sample size
rkernel="laplacian" # kernel choice
s=2  # sparsity, number of nonzero component functions
rk_scale=1  # scaling paramtere of kernel
rfn_range= c(2,3,4)  # number of random features
cv_folds=15  # folds of cross-validation in group lasso
n_stb=10 # number of subsampling
frac_stb=1/2 # fraction of subsample
nCores_para=2 # number of cores for parallelization
X=matrix(rnorm(n*p),n,p)\%*\%chol(toeplitz(0.3^(0:(p-1))))   # generate design
X_k = create.second_order(X) # generate knockoff
reg_coef=c(rep(1,s),rep(0,p-s))  # regression coefficient
reg_coef=reg_coef*(2*(rnorm(p)>0)-1)*sig_mag
y=X\%*\% reg_coef + rnorm(n) # response

rk_tune(X,y,X_k,rfn_range,n_stb,cv_folds,frac_stb,nCores_para,rkernel,rk_scale)


}
\author{
Xiaowu Dai, Xiang Lyu, Lexin Li
}
