% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk_subsample.R
\name{rk_subsample}
\alias{rk_subsample}
\title{compute selection frequency of rk_fit on subsamples}
\usage{
rk_subsample(
  X,
  y,
  X_k,
  rfn,
  n_stb,
  cv_folds,
  frac_stb = 1/2,
  nCores_para,
  rkernel = "laplacian",
  rk_scale = 1
)
}
\arguments{
\item{X}{design matrix of additive model; rows are observations and columns are variables.}

\item{y}{response of addtive model.}

\item{X_k}{knockoffs matrix of design; the same size as X.}

\item{rfn}{random feature expansion number.}

\item{n_stb}{number of subsampling.}

\item{cv_folds}{the folds of cross-validation for tuning group lasso.}

\item{frac_stb}{fraction of subsample size.}

\item{nCores_para}{number of cores for parallelizing subsampling.}

\item{rkernel}{kernel choices. Default is "laplacian". Other choices are "cauchy" and "gaussian".}

\item{rk_scale}{scaling parameter of sampling distribution for random feature expansion. For gaussian kernel, it is standard deviation of gaussian sampling distribution.}
}
\value{
a 0/1 matrix indicating selection results. Rows are subsamples, and columns are variables.
The first half columns are variables of design X, and the latter are knockoffs X_k.
}
\description{
The function applys rk_fit on subsamples and record selection results.
}
\examples{
library(knockoff)
p=5 # number of predictors
sig_mag=100 # signal strength
n= 100 # sample size
rkernel="laplacian" # kernel choice
s=2  # sparsity, number of nonzero component functions
rk_scale=1  # scaling paramtere of kernel
rfn= 3  # number of random features
cv_folds=15  # folds of cross-validation in group lasso
n_stb=10 # number of subsampling
frac_stb=1/2 # fraction of subsample
nCores_para=2 # number of cores for parallelization
X=matrix(rnorm(n*p),n,p)\%*\%chol(toeplitz(0.3^(0:(p-1))))   # generate design
X_k = create.second_order(X) # generate knockoff
reg_coef=c(rep(1,s),rep(0,p-s))  # regression coefficient
reg_coef=reg_coef*(2*(rnorm(p)>0)-1)*sig_mag
y=X\%*\% reg_coef + rnorm(n) # response

rk_subsample(X,y,X_k,rfn,n_stb,cv_folds,frac_stb,nCores_para,rkernel,rk_scale)


}
\author{
Xiaowu Dai, Xiang Lyu, Lexin Li
}
