% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlp_kindling.R
\name{mlp_kindling}
\alias{mlp_kindling}
\title{Multi-Layer Perceptron (Feedforward Neural Network) via kindling}
\usage{
mlp_kindling(
  mode = "unknown",
  engine = "kindling",
  hidden_neurons = NULL,
  activations = NULL,
  output_activation = NULL,
  bias = NULL,
  epochs = NULL,
  batch_size = NULL,
  penalty = NULL,
  mixture = NULL,
  learn_rate = NULL,
  optimizer = NULL,
  optimizer_args = NULL,
  loss = NULL,
  validation_split = NULL,
  device = NULL,
  verbose = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model. Possible values
are "unknown", "regression", or "classification".}

\item{engine}{A single character string specifying what computational engine
to use for fitting. Currently only "kindling" is supported.}

\item{hidden_neurons}{An integer vector for the number of units in each hidden
layer. Can be tuned.}

\item{activations}{A character vector of activation function names for each
hidden layer (e.g., "relu", "tanh", "sigmoid"). Can be tuned.}

\item{output_activation}{A character string for the output activation function.
Can be tuned.}

\item{bias}{Logical for whether to include bias terms. Can be tuned.}

\item{epochs}{An integer for the number of training iterations. Can be tuned.}

\item{batch_size}{An integer for the batch size during training. Can be tuned.}

\item{penalty}{A number for the regularization penalty (lambda). Default \code{0}
(no regularization). Higher values increase regularization strength. Can be tuned.}

\item{mixture}{A number between 0 and 1 for the elastic net mixing parameter.
Default \code{0} (pure L2/Ridge regularization).
\itemize{
\item \code{0}: Pure L2 regularization (Ridge)
\item \code{1}: Pure L1 regularization (Lasso)
\item \verb{0 < mixture < 1}: Elastic net (combination of L1 and L2)
Only relevant when \code{penalty > 0}. Can be tuned.
}}

\item{learn_rate}{A number for the learning rate. Can be tuned.}

\item{optimizer}{A character string for the optimizer type ("adam", "sgd",
"rmsprop"). Can be tuned.}

\item{optimizer_args}{A named list of additional arguments passed to the optimizer.
Cannot be tuned.}

\item{loss}{A character string for the loss function ("mse", "mae",
"cross_entropy", "bce"). Cannot be tuned.}

\item{validation_split}{A number between 0 and 1 for the proportion of data
used for validation. Can be tuned.}

\item{device}{A character string for the device to use ("cpu", "cuda", "mps").
If NULL, auto-detects available GPU. Cannot be tuned.}

\item{verbose}{Logical for whether to print training progress. Default FALSE.
Cannot be tuned.}
}
\value{
A model specification object with class \code{mlp_kindling}.
}
\description{
\code{mlp_kindling()} defines a feedforward neural network model that can be used
for classification or regression. It integrates with the tidymodels ecosystem
and uses the torch backend via kindling.
}
\details{
This function creates a model specification for a feedforward neural network
that can be used within tidymodels workflows. The model supports:
\itemize{
\item Multiple hidden layers with configurable units
\item Various activation functions per layer
\item GPU acceleration (CUDA, MPS, or CPU)
\item Hyperparameter tuning integration
\item Both regression and classification tasks
}

The \code{hidden_neurons} parameter accepts an integer vector where each element
represents the number of neurons in that hidden layer. For example,
\code{hidden_neurons = c(128, 64, 32)} creates a network with three hidden layers.

The \code{device} parameter controls where computation occurs:
\itemize{
\item \code{NULL} (default): Auto-detect best available device (CUDA > MPS > CPU)
\item \code{"cuda"}: Use NVIDIA GPU
\item \code{"mps"}: Use Apple Silicon GPU
\item \code{"cpu"}: Use CPU only
}

When tuning, you can use special tune tokens:
\itemize{
\item For \code{hidden_neurons}: use \code{tune("hidden_neurons")} with a custom range
\item For \code{activation}: use \code{tune("activation")} with values like "relu", "tanh"
}
}
\examples{
\donttest{
if (torch::torch_is_installed()) {
    box::use(
        recipes[recipe],
        workflows[workflow, add_recipe, add_model],
        tune[tune],
        parsnip[fit]
    )

    # Model specs
    mlp_spec = mlp_kindling(
        mode = "classification",
        hidden_neurons = c(128, 64, 32),
        activation = c("relu", "relu", "relu"),
        epochs = 100
    )

    # If you want to tune
    mlp_tune_spec = mlp_kindling(
        mode = "classification",
        hidden_neurons = tune(),
        activation = tune(),
        epochs = tune(),
        learn_rate = tune()
    )
     wf = workflow() |>
        add_recipe(recipe(Species ~ ., data = iris)) |>
        add_model(mlp_spec)

     fit_wf = fit(wf, data = iris)
} else {
    message("Torch not fully installed — skipping example")
}
}

}
