% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk.R
\name{add_kfre_risk_col}
\alias{add_kfre_risk_col}
\title{Add KFRE risk columns to a data frame}
\usage{
add_kfre_risk_col(
  df,
  age_col = NULL,
  sex_col = NULL,
  eGFR_col = NULL,
  uACR_col = NULL,
  dm_col = NULL,
  htn_col = NULL,
  albumin_col = NULL,
  phosphorous_col = NULL,
  bicarbonate_col = NULL,
  calcium_col = NULL,
  num_vars = 8,
  years = c(2, 5),
  is_north_american = FALSE,
  copy = TRUE,
  precision = NULL
)
}
\arguments{
\item{df}{Data frame with predictor columns.}

\item{age_col}{Column name for age.}

\item{sex_col}{Column name for sex, text or integer accepted.}

\item{eGFR_col}{Column name for eGFR, mL/min/1.73 m^2.}

\item{uACR_col}{Column name for uACR, mg/g.}

\item{dm_col}{Optional column name for diabetes indicator.}

\item{htn_col}{Optional column name for hypertension indicator.}

\item{albumin_col}{Optional column name for serum albumin, g/dL.}

\item{phosphorous_col}{Optional column name for serum phosphorus, mg/dL.}

\item{bicarbonate_col}{Optional column name for bicarbonate, mmol/L.}

\item{calcium_col}{Optional column name for calcium, mg/dL.}

\item{num_vars}{Integer or vector, one of 4, 6, 8.}

\item{years}{Integer or vector, any of 2, 5.}

\item{is_north_american}{Logical, use North American calibration.}

\item{copy}{Logical, if TRUE work on a copy of \code{df}.}

\item{precision}{Optional integer, digits to round probabilities.}
}
\value{
The input data frame with added \verb{kfre_<n>var_<y>year} columns.
}
\description{
Adds KFRE risk columns for selected model sizes and horizons using
the 4, 6, or 8 variable equations.
}
\examples{
df <- data.frame(
  age = 60L, sex = 1L, eGFR = 30, uACR = 500,
  dm = 1L, htn = 0L, albumin = 40,
  phosphorous = 1.1, bicarbonate = 24, calcium = 9.2
)

add_kfre_risk_col(
  df,
  age_col = "age", sex_col = "sex",
  eGFR_col = "eGFR", uACR_col = "uACR",
  num_vars = 4, years = 2
)
}
\references{
Tangri, N., Stevens, L. A., Griffith, J., Tighiouart, H., Djurdjev, O., Naimark, D., Levin, A., &
Levey, A. S. (2011). A predictive model for progression of chronic kidney disease to kidney failure.
\emph{JAMA}, 305(15), 1553–1559. \doi{10.1001/jama.2011.451}

Tangri, N., Grams, M. E., Levey, A. S., et al. (2016). Multinational assessment of the accuracy of the
Kidney Failure Risk Equation in people with chronic kidney disease. \emph{JAMA}, 315(2), 164–174.
\doi{10.1001/jama.2015.18202}
}
