% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kairos-package.R
\docType{package}
\name{kairos-package}
\alias{kairos-package}
\alias{kairos}
\title{kairos: Analysis of Chronological Patterns from Archaeological Count Data}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

A toolkit for absolute and relative dating and analysis of chronological patterns. This package includes functions for chronological modeling and dating of archaeological assemblages from count data. It provides methods for matrix seriation. It also allows to compute time point estimates and density estimates of the occupation and duration of an archaeological site.
}
\details{
\tabular{ll}{
\strong{Version} \tab 2.3.0 \cr
\strong{License} \tab GPL-3 \cr
\strong{CRAN DOI} \tab \doi{10.32614/CRAN.package.kairos} \cr
\strong{Zenodo DOI} \tab \doi{10.5281/zenodo.5653896} \cr
}

Archéosciences Bordeaux (UMR 6034)\cr
Maison de l'Archéologie\cr
Université Bordeaux Montaigne\cr
F-33607 Pessac cedex\cr
France
}
\section{Package options}{

\pkg{kairos} uses the following \code{\link[=options]{options()}} to configure behavior:
\itemize{
\item \code{kairos.progress}: a \code{\link{logical}} scalar. Should progress bars be
displayed? Defaults to \code{\link[=interactive]{interactive()}}.
\item \code{kairos.verbose}: a \code{\link{logical}} scalar. Should \R report extra information
on progress? Defaults to \code{\link[=interactive]{interactive()}}.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://codeberg.org/tesselle/kairos}
  \item \url{https://packages.tesselle.org/kairos/}
  \item \url{https://tesselle.r-universe.dev/kairos}
  \item Report bugs at \url{https://codeberg.org/tesselle/kairos/issues}
}

}
\author{
\strong{Maintainer}: Nicolas Frerebeau \email{nicolas.frerebeau@u-bordeaux-montaigne.fr} (\href{https://orcid.org/0000-0001-5759-4944}{ORCID})

Other contributors:
\itemize{
  \item Brice Lebrun (\href{https://orcid.org/0000-0001-7503-8685}{ORCID}) (Logo designer) [artist]
  \item Ben Marwick \email{bmarwick@uw.edu} (\href{https://orcid.org/0000-0001-7879-4531}{ORCID}) [contributor]
  \item Anne Philippe \email{anne.philippe@univ-nantes.fr} (\href{https://orcid.org/0000-0002-5331-5087}{ORCID}) [contributor]
  \item Université Bordeaux Montaigne (03pbgwk21) [funder]
  \item CNRS (02feahw73) [funder]
}

}
\keyword{internal}
