% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_freq_resp_var_j.R
\name{a_freq_resp_var_j}
\alias{a_freq_resp_var_j}
\title{Analysis Function for Response Variables}
\usage{
a_freq_resp_var_j(
  df,
  .var,
  .df_row,
  .N_col,
  .spl_context,
  resp_var = NULL,
  id = "USUBJID",
  drop_levels = FALSE,
  riskdiff = TRUE,
  ref_path = NULL,
  variables = formals(s_proportion_diff)$variables,
  conf_level = formals(s_proportion_diff)$conf_level,
  method = c("wald", "waldcc", "cmh", "ha", "newcombe", "newcombecc", "strat_newcombe",
    "strat_newcombecc"),
  weights_method = formals(s_proportion_diff)$weights_method,
  ...
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr variable name that is passed by \code{rtables}.}

\item{.df_row}{(\code{data.frame})\cr data frame across all of the columns for the given row split.}

\item{.N_col}{(\code{integer})\cr column-wise N (column count) for the full column being analyzed.}

\item{.spl_context}{(\code{data.frame})\cr gives information about ancestor split states.}

\item{resp_var}{(\code{string})\cr response variable name containing Y/N values.}

\item{id}{(\code{string})\cr subject variable name.}

\item{drop_levels}{(\code{logical})\cr if TRUE, non-observed levels will not be included.}

\item{riskdiff}{(\code{logical})\cr if TRUE, risk difference calculations will be performed.}

\item{ref_path}{(\code{string})\cr column path specifications for the control group.}

\item{variables}{(\code{list})\cr variables to include in the analysis.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{method}{(\code{character})\cr method for calculating confidence intervals.}

\item{weights_method}{(\code{character})\cr method for calculating weights.}

\item{...}{Additional arguments passed to other functions.}
}
\value{
Formatted analysis function which is used as \code{afun} in \code{analyze_vars()}
and as \code{cfun} in \code{summarize_row_groups()}.
}
\description{
This function calculates counts and percentages for response variables (Y/N values),
with optional risk difference calculations.
}
\examples{
library(dplyr)
ADSL <- ex_adsl |> select(USUBJID, ARM, SEX)

ADAE <- ex_adae |> select(USUBJID, ARM, SEX, AEBODSYS, AEDECOD)

ADAE <- ADAE |>
  mutate(TRTEMFL = "Y")

lyt <- basic_table(show_colcounts = TRUE) |>
  split_cols_by("ARM") |>
  analyze("SEX",
    show_labels = "visible",
    afun = a_freq_resp_var_j,
    extra_args = list(resp_var = "TRTEMFL", riskdiff = FALSE)
  )

result <- build_table(lyt, df = ADAE, alt_counts_df = ADSL)

result
}
