% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{dummyseas}
\alias{dummyseas}
\title{Seasonal dummy variables}
\usage{
dummyseas(n, s, remove = s)
}
\arguments{
\item{n}{length of time series;}

\item{s}{seasonal period;}

\item{remove}{to avoid collinearity with the constant
remove a column, by default it is column s; if NULL no
column is removed.}
}
\value{
It returns a matrix with \eqn{n} rows and \eqn{s-1}
column unless \code{remove = NULL}.
}
\description{
It produces a matrix with seasonal dummies summing to zero
to be used as regressors. If \eqn{s} is the seasonal period,
then the  \eqn{j}-th dummy equals 1 in season \eqn{j} and
\eqn{-1/(s-1)} in the other seasons, so that the variable
sums to 0 over one year period.
}
\examples{
y <- log(AirPassengers)
X <- dummyseas(length(y), 12)
X <- cbind(X, t = 1:length(y))
reg <- lm(y~X)
}
