% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{da}
\alias{da}
\title{Internal function for computing scores w/r to regression coefficients}
\usage{
da(k1, k2, X, A1, A2)
}
\arguments{
\item{k1}{numeric vector of n elements with the Kalman gain sequence for
the first state variable;}

\item{k2}{numeric vector of n elements with the Kalman gain sequence for
the second state variable;}

\item{X}{numeric matrix of dimension \eqn{n\times k} with the regressors;}

\item{A1}{numeric matrix of dimension \eqn{n\times k} that, after calling
the function will contain the sequence of gradients \eqn{D a^{(1)}_t}; the
first row must be of zero values;}

\item{A2}{numeric matrix of dimension \eqn{n\times k} that, after calling
the function will contain the sequence of gradients \eqn{D a^{(2)}_t}; the
first row must be of zero values;}
}
\value{
It does not return anything as it writes on the A1 and A2 matrices
passed as reference.
}
\description{
This function, not intended for end-users, implements the following
recursions needed in computing scores with respect to regression
coefficients:
\deqn{D a^{(1)}_{t+1} = D a^{(1)}_{t} + D a^{(2)}_{t} - k^{(1)}_t x_t -
k^{(1)}_t D a^{(1)}_{t}}
\deqn{D a^{(2)}_{t+1} = a^{(2)}_{t} - k^{(2)}_t x_t - k^{(2)}_t Da^{(1)}_{t}}
where \eqn{a^{(1)}_{t}}, \eqn{a^{(2)}_{t}} are the one-step-ahead Kalman filtered
state variables, and \eqn{k^{(1)}_{t}}, \eqn{k^{(2)}_{t}} the respective
Kalman gain elements. The symbol $D$ represent the partial derivative with
respect to the regression coefficients and $x_t$ is the vector of regressors.
All variables are passed by reference and, so, no output is needed.
}
