# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Internal function for computing scores w/r to regression coefficients
#' 
#' This function, not intended for end-users, implements the following
#' recursions needed in computing scores with respect to regression
#' coefficients:
#' \deqn{D a^{(1)}_{t+1} = D a^{(1)}_{t} + D a^{(2)}_{t} - k^{(1)}_t x_t -
#' k^{(1)}_t D a^{(1)}_{t}}
#' \deqn{D a^{(2)}_{t+1} = a^{(2)}_{t} - k^{(2)}_t x_t - k^{(2)}_t Da^{(1)}_{t}}
#' where \eqn{a^{(1)}_{t}}, \eqn{a^{(2)}_{t}} are the one-step-ahead Kalman filtered
#' state variables, and \eqn{k^{(1)}_{t}}, \eqn{k^{(2)}_{t}} the respective
#' Kalman gain elements. The symbol $D$ represent the partial derivative with
#' respect to the regression coefficients and $x_t$ is the vector of regressors.
#' All variables are passed by reference and, so, no output is needed.
#' 
#' @param k1 numeric vector of n elements with the Kalman gain sequence for
#' the first state variable;
#' @param k2 numeric vector of n elements with the Kalman gain sequence for
#' the second state variable;
#' @param X numeric matrix of dimension \eqn{n\times k} with the regressors;
#' @param A1 numeric matrix of dimension \eqn{n\times k} that, after calling
#' the function will contain the sequence of gradients \eqn{D a^{(1)}_t}; the
#' first row must be of zero values;
#' @param A2 numeric matrix of dimension \eqn{n\times k} that, after calling
#' the function will contain the sequence of gradients \eqn{D a^{(2)}_t}; the
#' first row must be of zero values;
#' @returns It does not return anything as it writes on the A1 and A2 matrices
#' passed as reference.
da <- function(k1, k2, X, A1, A2) {
    invisible(.Call(`_jumps_da`, k1, k2, X, A1, A2))
}

#' Kalman filtering and smoothing for local linear trend plus noise
#' 
#' It uses the power of C++, scalar computation and pointers
#' to run the Kalman filter, the smoother and compute the log-likelihood.
#' The R user has to supply many vectors that in most cases will be
#' overwritten by the llt() function since they are passed by reference.
#' All passed parameters must be numerical (floating point) vectors:
#' any other kind of variable may cause serious problems to the stability
#' of your system. Passing vectors of integers will make the computations fail.
#'  
#' @param y vector of n observations
#' @param var_eps vector of n variances for the observation noises
#' @param var_eta vector of n variances for the level disturbances
#' @param var_zeta vector of n variances for the slope disturbances
#' @param cov_eta_zeta vector of n covariances between level and slope disturbances
#' @param a1 vector of n+1 one-step-ahead prediction of the level; the first
#' element is the initial condition for the level at time t=1, the other elements
#' are arbitrary and will be overwritten
#' @param a2 vector of n+1 one-step-ahead prediction of the slope; the first
#' element is the initial condition for the slope at time t=1, the other elements
#' are arbitrary and will be overwritten
#' @param p11 vector of n+1 one-step-ahead prediction error variance of the level;
#' the first element is the initial condition for the level at time t=1, the other elements
#' are arbitrary and will be overwritten
#' @param p12 vector of n+1 one-step-ahead prediction covariances for level and slope;
#' the first element is the initial condition for the slope at time t=1, the other elements
#' are arbitrary and will be overwritten
#' @param p22 vector of n+1 one-step-ahead prediction error variance of the slope;
#' the first element is the initial condition for the level at time t=1, the other elements
#' are arbitrary and will be overwritten
#' @param k1 vector of the n Kalman gains for the level equation; values are
#' arbitrary and will be overwritten;
#' @param k2 vector of the n Kalman gains for the slope equation; values are
#' arbitrary and will be overwritten;
#' @param i vector of the n innovations; values are
#' arbitrary and will be overwritten;
#' @param f vector of the n innovatoin variances;values are
#' arbitrary and will be overwritten;
#' @param r1 vector of the n+1 smoothers (Th.5.4 in Pelagatti, 2015)
#' for the level equation; values are arbitrary and will be overwritten;
#' @param r2 vector of the n+1 smoothers (Th.5.4 in Pelagatti, 2015) for
#' the slope equation; values are arbitrary and will be overwritten;
#' @param n11 vector of the n+1 variance smoothers (Th.5.4 in Pelagatti, 2015) for the level
#' equation; values are arbitrary and will be overwritten;
#' @param n12 vector of the n+1 covariance smoothers (Th.5.4 in Pelagatti, 2015) for the level
#' and slope; values are arbitrary and will be overwritten;
#' @param n22 vector of the n+1 variance smoothers (Th.5.4 in Pelagatti, 2015) for the slope
#' equation; values are arbitrary and will be overwritten;
#' @param e vector of the n+1 observation error smoothers (Th.5.4 in Pelagatti, 2015);
#' values are arbitrary and will be overwritten;
#' @param d vector of the n+1 observation error variance smoothers (Th.5.4 in Pelagatti, 2015);
#' values are arbitrary and will be overwritten;
#' @param w_ NULL (default) or vector of n weights for the effect of observation y_t
#' on the estimation of the hp filter (with jumps) at time t;
#' values are arbitrary and will be overwritten;
#' @return The value of the Gaussian log-likelihood net of the -log(2*pi)*n/2 part
#' that can be added if needed.
llt <- function(y, var_eps, var_eta, var_zeta, cov_eta_zeta, a1, a2, p11, p12, p22, k1, k2, i, f, r1, r2, n11, n12, n22, e, d, w_ = NULL) {
    .Call(`_jumps_llt`, y, var_eps, var_eta, var_zeta, cov_eta_zeta, a1, a2, p11, p12, p22, k1, k2, i, f, r1, r2, n11, n12, n22, e, d, w_)
}

