% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Best.Index.R
\name{Best.Index}
\alias{Best.Index}
\title{Jack-knife indices in a single topology m times and evaluates a 
success rule.}
\usage{
Best.Index(tree = tree, distribution = distribution, jtip = jtip,
  replicates = replicates, success = c(success))
}
\arguments{
\item{tree}{is a single tree with n terminals, an ape phylo object.}

\item{distribution}{species distributions in n areas, a data.frame}

\item{jtip}{is the proportion of terminals to delete, real (range 0-1).}

\item{replicates}{is the number of replicates, an integer.}

\item{success}{the measure of the success, a vector.}
}
\value{
The function returns the success that correspond to  
obtain the same ranking for X,Y positions, established as the vector
success (by default success)).

The function returns the success that corresponds to  
obtain the same ranking for X,Y positions, established as the vector
success (by default success))
}
\description{
The function jack-knifes the terminals and
calculates the indices value m (=replicates) times.
}
\examples{
library(jrich)
data(tree)
data(distribution)

Best.Index(tree = tree, distribution = distribution, jtip =0.5, replicates =10, success=1)


}
\author{
Miranda-Esquivel Daniel R.
}

