% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{SimData}
\alias{SimData}
\title{A simulated dataset for use with jrSiCKLSNMF}
\format{
A list made up of a two items. The first is list of 2 simulated sparse matrices
and the second is a vector containing cell identities.
\describe{
\item{Xmatrices}{A list of 2 sparse matrices, each containing a different
simulated omics modality measured on the same set of single cells: the first entry in the list
corresponds to simulated scRNA-seq data and has 1000 genes and 300 cells; the second entry in
the list corresponds to simulated scATAC-seq data and has 5910 peaks and 300
cells.}
\item{cell_type}{A vector containing the cell-type identities of the simulated data}}
}
\source{
\href{https://github.com/ellisdoro/jrSiCKLSNMF_Simulations}{jrSicKLSNMF Simulations}
}
\usage{
data(SimData)
}
\description{
A simulated dataset with \eqn{\mathcal{U}(1,1.25)} multiplicative noise for the
scRNA-seq variability parameter in SPARSim for the simulated scRNA-seq data and
with \eqn{\mathcal{N}(-0.25,0.25)} additive noise to the expression levels of the scATAC-seq data
for data simulated via SimATAC. The simulated matrices are located in SimData$Xmatrices
and the identities for the cell types are contained in SimData$cell_type. This corresponds
to the Xmatrix data found in both

XandLmatrices25/XandindividLKNNLmatrices1Sparsity5.RData and

XandBulkLmatrix25/XandBulkLKNNmatrices1Sparsity5.RData on our Github

\href{https://github.com/ellisdoro/jrSiCKLSNMF_Simulations}{ellisdoro/jrSiCKLSNMF_Simulations}
}
\keyword{datasets}
