% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoGroupDesignMatrix.R
\name{twoGroupDesignMatrix}
\alias{twoGroupDesignMatrix}
\title{Design Matrix for Two-Group Mean Estimation}
\usage{
twoGroupDesignMatrix(group.one.indices, group.two.indices)
}
\arguments{
\item{group.one.indices}{indices of observations in group one.}

\item{group.two.indices}{indices of observations in group two.}
}
\value{
Returns a design matrix of size n by 2, where n is
the sample size.
}
\description{
This function returns the design matrix for two-group mean
estimation.  The first column contains indicators for
membership in the first group, and the second column contains
indicators for memebership in the second group.
}
\details{
\bold{Example}
\preformatted{D <- twoGroupDesignMatrix(1:2, 3:5)
# print(D) displays the following:
     [,1] [,2]
[1,]    1    0
[2,]    1    0
[3,]    0    1
[4,]    0    1
[5,]    0    1
}
}
