% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/job.R
\encoding{UTF-8}
\name{job}
\alias{job}
\alias{empty}
\title{Run Code as an RStudio Job}
\usage{
job(
  ...,
  import = "all",
  packages = .packages(),
  opts = options(),
  title = NULL
)

empty(..., import = NULL, packages = NULL, opts = NULL, title = NULL)
}
\arguments{
\item{...}{A named or unnamed code block enclosed in curly brackets, \code{{}}.
Named code blocks will assign the that name in \code{globalenv()}.
Unnamed code blocks will assign job variables directly to \code{globalenv()}
upon completion. Control what gets returned using \code{\link[job]{export}} within
the code block.}

\item{import}{Which objects to import into the job.
\itemize{
\item \code{"all"}: Import all objects.
\item \code{"auto"} (default): Detect which objects are used in the code and import
those.
\item \code{c(foo, bar, ...)}: A vector of unquoted variables to import into the job.
\item \code{c("foo", "bar", ...)}: A vector of quoted variables to import into the job.
\item \code{NULL}: import nothing.
}}

\item{packages}{Character vector of packages to load in the job. Defaults to
all loaded packages in the calling environment. \code{NULL} loads only default
packages. You can combine \code{packages = NULL} with writing \code{library(my_package)}
in the code block.}

\item{opts}{List of options to overwrite in the job. Defaults to \code{options()},
i.e., copy all options to the job. \code{NULL} uses defaults.}

\item{title}{The job title. You can write e.g., \code{"Cross-Validation: {code}"} to
include a code snippet in the title. If \code{title = NULL} (default), the name of the
code chunk is used. If \code{...} is unnamed, the code is shown.}
}
\value{
Invisibly returns the job id on which you can call other \verb{rstudioapi::job*}
functions, e.g., \verb{rstudioapi::rstudioapi::jobRemove(job_id)}.
}
\description{
See examples for an introduction. See \href{https://lindeloev.github.io/job/}{the job website} for more examples.
See details for some warnings.
Note that \code{job::empty()}is identical to \code{job::job()} but all arguments default to \code{NULL}.
}
\details{
This is a wrapper around \code{rstudioapi::jobRunScript}. To control what gets
returned, see \code{\link[job]{export}}. By default, all objects that \emph{changed} during
the job are returned, i.e., \code{job::export("changed")}.
\itemize{
\item \strong{Returning large objects:}\code{jobRunScript} is very
slow at importing and exporting large objects. For exporting back into
\code{globalenv()}, it may be faster to \code{saveRDS()} results within the job and
\code{readRDS()} them in your environment.
}
}
\section{Functions}{
\itemize{
\item \code{empty()}: \code{job::job()} but with NULL defaults, i.e., an "empty" job.

}}
\examples{
if (rstudioapi::isAvailable()) {
  # Unnamed code chunks returns to globalenv()
  global_var = 5
  job::job({
    x = rnorm(global_var)
    print("This text goes to the job console")
    m = mean(x)
  })

  # later:
  print(x)
  print(m)


  # Named code chunks assign job environment to that name
  job::job(my_result = {
    y = rnorm(global_var)
    sigma = sd(y)
  }, title = "Title with code: {code}")

  # later:
  print(my_result$y)
  print(my_result$sigma)


  # Delete everything in the job environment to return nothing.
  # Useful if text output + file output is primary
  job::job({
    some_cars = mtcars[mtcars$cyl > 4, ]
    print(mean(some_cars$mpg))
    print(summary(some_cars))
    # saveRDS(some_cars, "job_result.rds")

    job::export("none")  # return nothing
  })


  # Control imports from calling environment (variables, packages, options)
  my_df = data.frame(names = c("alice", "bob"))
  ignore_var = 15
  job::job(result2 = {
    if (exists("ignore_var") == FALSE)
      print("ignore_var is not set here")

    names = rep(my_df$names, global_var)
  }, import = c(global_var, my_df), packages = NULL, opts = list(mc.cores = 3))

  # later
  print(result2$names)
}
}
\seealso{
\code{\link[job]{export}}, \code{\link[rstudioapi]{jobRunScript}}
}
\author{
Jonas Kristoffer Lindeløv, \email{jonas@lindeloev.dk}
}
