% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{marginal_slices}
\alias{marginal_slices}
\title{Marginal Effect Slices}
\usage{
marginal_slices(
  object,
  transition,
  n_points = 60,
  quantiles = c(0.25, 0.5, 0.75),
  colors = c("#264653", "#e76f51", "#2a9d8f"),
  main = NULL,
  ...
)
}
\arguments{
\item{object}{A \code{"jmSurface"} object.}

\item{transition}{Character string specifying which transition.}

\item{n_points}{Integer number of evaluation points. Default \code{60}.}

\item{quantiles}{Numeric vector of quantile probabilities for slicing.
Default \code{c(0.25, 0.50, 0.75)}.}

\item{colors}{Character vector of colors for each slice. Default blue/orange/red.}

\item{main}{Title. If \code{NULL}, auto-generated.}

\item{...}{Additional arguments passed to \code{plot}.}
}
\value{
Invisibly returns the data frame of slice values.
}
\description{
Produces marginal effect slice plots showing the effect of one biomarker
on the log-hazard at fixed quantiles (Q25, Q50, Q75) of the other.
Diverging slices indicate interaction; parallel slices indicate additivity.
}
