% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.R
\name{plotdens}
\alias{plotdens}
\title{Plot kernel densities of single parameter nodes}
\usage{
plotdens(
  df,
  p = NULL,
  exact = FALSE,
  add = FALSE,
  col = NULL,
  shade = TRUE,
  lwd = 2,
  minCI = 0.99,
  legend = TRUE,
  legendpos = "topleft",
  legendnames = NULL,
  main = NULL,
  xlab = "",
  ylab = "Density",
  ...
)
}
\arguments{
\item{df}{Input object for plotting.  See examples below.}

\item{p}{Vector of parameter names, if \code{df} is given as a single or list of output objects
from \code{jagsUI}}

\item{exact}{Whether the \verb{p=} argument should match the parameter name exactly.  See
\link{jags_df} for details.}

\item{add}{Whether to add to an existing plot (\code{TRUE}) or produce a new plot.
Defaults to \code{FALSE}.}

\item{col}{Vector of colors for plotting.  If the default (\code{NULL}) is accepted,
colors will be automatically selected.}

\item{shade}{Whether to shade the regions below the kernel density curve(s).
Defaults to \code{TRUE}.}

\item{lwd}{Line width for kernel density curves.  Defaults to \code{2}.  Note: setting
this to \code{0} (or \code{FALSE}) will suppress lines.}

\item{minCI}{Minimum CI width to include for all density curves.  Defaults to 99\%.}

\item{legend}{Whether to plot a legend.  Defaults to \code{TRUE}.}

\item{legendpos}{Position for automatic legend.  Defaults to \code{"topleft"}.}

\item{legendnames}{Names for legend}

\item{main}{Plot title.  Defaults to "".}

\item{xlab}{X-axis label.  Defaults to "".}

\item{ylab}{Y-axis label.  Defaults to "Density".}

\item{...}{Optional plotting arguments}
}
\value{
\code{NULL}
}
\description{
Produces a kernel density plot of a single or multiple parameter nodes (overlayed).

Input can be of multiple possible formats: either a single or list of output objects
from \code{jagsUI} with an associated vector of parameter names, or a vector or \code{data.frame}
of posterior samples.
}
\examples{
## jagsUI object with a single parameter
plotdens(asdf_jags_out, p="b1")

## jagsUI object with multiple nodes of a parameter
plotdens(asdf_jags_out, p="a")

## jagsUI object with multiple parameter nodes
plotdens(asdf_jags_out, p=c("a[1]","a[2]","a[3]"))

## data.frame with multiple columns
plotdens(jags_df(asdf_jags_out, p="a"))

## list of jagsUI objects with a single parameter name
plotdens(list(asdf_jags_out,asdf_jags_out,asdf_jags_out), p="b1")

## list of jagsUI objects with a vector of parameter names
plotdens(list(asdf_jags_out,asdf_jags_out,asdf_jags_out), p=c("a[1]","a[2]","a[3]"))
}
\seealso{
\link{comparedens}, \link{comparecat}, \link{comparepriors}
}
\author{
Matt Tyers
}
