% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_k.R
\name{permutationPA}
\alias{permutationPA}
\title{Permutation Parallel Analysis}
\usage{
permutationPA(dat, B = 100, threshold = 0.05, verbose = TRUE)
}
\arguments{
\item{dat}{a data matrix with \code{m} rows as variables and \code{n} columns as observations.}

\item{B}{a number (a positive integer) of resampling iterations.}

\item{threshold}{a numeric value between 0 and 1 to threshold p-values.}

\item{verbose}{a logical indicator as to whether to print the progress.}
}
\value{
\code{permutationPA} returns
\item{r}{an estimated number of significant principal components based on thresholding p-values at \code{threshold}}
\item{p}{a list of p-values for significance of principal components}
}
\description{
Estimate a number of significant principal components from a permutation test.
}
\details{
Adopted from \code{sva::num.sv}, and based on Buja and Eyuboglu (1992)
}
\references{
Buja A and Eyuboglu N. (1992) Remarks on parallel analysis. Multivariate Behavioral Research, 27(4), 509-540
}
