% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackknife.R
\name{jackknife}
\alias{jackknife}
\title{Delete-d Jackknife for Estimates}
\usage{
jackknife(
  statistic,
  d = 1,
  data,
  conf = 0.95,
  numCores = detectCores(),
  weight = FALSE,
  hat_values = NULL,
  residuals = NULL,
  X = NULL,
  p = NULL
)
}
\arguments{
\item{statistic}{a function returning a vector of estimates to be passed to jackknife}

\item{d}{Number of observations to be deleted from data to make jackknife samples. The default is 1 (for delete-1 jackknife).}

\item{data}{Data frame with dependent and independent independent variables specified in the formula}

\item{conf}{Confidence level, a positive number < 1. The default is 0.95.}

\item{numCores}{Number of processors to be used}

\item{weight}{Logical, TRUE for weighted jackknife standard error of regression estimates. Default weight = FALSE}

\item{hat_values}{Vector of hat values (leverages) from the model. Required if `weight = TRUE}

\item{residuals}{Vector of residuals from the model. Required if \code{weight = TRUE}.}

\item{X}{Model matrix. Required if \code{weight = TRUE}.}

\item{p}{Number of predictors in the model. Required if \code{weight = TRUE}.}
}
\value{
A list containing a summary data frame of jackknife estimates
with bias, standard error. t-statistics, and confidence intervals,
estimate for the original sample and a data frame with
estimates for jackknife samples.
}
\description{
This function creates jackknife samples from the data by
sequentially removing \emph{d} observations from the data,
and calculates the estimates by the specified function and its bias,
standard error, and confidence intervals.
}
\examples{
library(future)
plan(multisession)  # Initialize once per session
# For linear regression coefficients
jk_results <- jackknife(
statistic = function(sub_data) coef(lm(mpg ~ wt + hp, data = sub_data)),
d = 2,
data = mtcars,
conf = 0.95, numCores = 2)
print(jk_results)
}
\references{
Quenouille, M. H. (1956). Notes on Bias in Estimation.
\emph{Biometrika}, \emph{43}(3/4), 353-360.
\doi{10.2307/2332914}

Tukey, J. W. (1958). Bias and Confidence in Not-quite Large Samples.
\emph{Annals of Mathematical Statistics}, \emph{29}(2), 614-623.
\doi{10.1214/aoms/1177706647}

Shi, X. (1988). A note on the delete-d jackknife variance estimators.
\emph{Statistics & Probability Letters}, \emph{6}(5), 341-347.
\doi{10.1016/0167-7152(88)90011-9}
}
\seealso{
\code{\link[=jackknife.lm]{jackknife.lm()}} which is used for jackknifing in linear regression.
}
