% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaccard.rahman.R
\name{jaccard.rahman}
\alias{jaccard.rahman}
\title{Compute p-value using an extreme value distribution}
\usage{
jaccard.rahman(j)
}
\arguments{
\item{j}{a numeric vector of observed Jaccard coefficients (uncentered)}
}
\value{
\code{jaccard.rahman} returns a numeric vector of p-values
}
\description{
Rahman et al. (2014) proposes a method to compute a p-value of 
a Jaccard/Tanimoto coefficient using an extreme value distribution.
Their paper provides the following description:
The mean (mu) and s.d. (sigma) of the similarity scores are used to
define the z score, z = (Tw - mu)/sigma. For the purpose of calculating
the P value, only hits with T > 0 are considered. The P value w
is derived from the z score using an extreme value distribution
P = 1 - exp(-e-z*pi/sqrt(6) - G'(1)), where the Euler=Mascheroni constant G'(1)=0.577215665.
}
\references{
Rahman, Cuesta, Furnham, Holliday, and Thornton (2014) EC-BLAST: a tool to automatically search and compare enzyme reactions. Nature Methods, 11(2) \url{http://www.nature.com/nmeth/journal/v11/n2/full/nmeth.2803.html}
}
