% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish_wiki.R
\name{publish_wiki}
\alias{publish_wiki}
\title{Publish into wiki repo}
\usage{
publish_wiki(
  rmarkdown,
  path_wiki_repo,
  automatic_update = FALSE,
  quiet_render_logs = FALSE
)
}
\arguments{
\item{rmarkdown}{the path of rmarkdown file}

\item{path_wiki_repo}{the complete path of wiki repository.}

\item{automatic_update}{if you like to do automatically the pull, commit and
push set in TRUE, if you like to do manually, set FALSE. Default is TRUE.}

\item{quiet_render_logs}{if you like to see the render logs of rmarkdown,
set in TRUE, in otherwise set FALSE. Default is TRUE.}
}
\value{
Publish a md into wiki repository
}
\description{
Publish an specific rmarkdown into wiki repository, specifying
the path of the wiki repository once that you already clone this repository
into your machine. See Details if is your first time publishing in a wiki
repository.
}
\details{
Publish an rmarkdown into wiki repo

If this is the first time you are going to publish in a wiki, you
must follow these steps:
\enumerate{
\item The wiki repository must be cloned to a local working folder. To do this
first go to the wiki tab of your repository and you will need to manually
create the first wiki page. If you don't do this it will tell you that the
repository does not exist.
\item Once you have created the wiki home page, you will need to clone the wiki
repository just like you would any other repository on your computer (using
the link that is made available to you once you create the wiki home page).
\item Once you have cloned the wiki on your computer, what you should indicate
in the \code{publica_wiki} function is the\code{ path_wiki_repo}. This is the full
address on your computer where this repository you cloned is located. For
example: \verb{/home/client/project/wiki_repo}
}
}
\examples{

\dontrun{
publish_wiki(rmarkdown = "eda.Rmd",
             path_wiki_repo = "/home/cliente/proyecto/wiki_repo")
}

}
