% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp.R
\name{qpSetupBound}
\alias{qpSetupBound}
\title{Constructing QCQP problem for bounding}
\usage{
qpSetupBound(
  env,
  g0,
  g1,
  criterion.tol,
  criterion.min,
  rescale = FALSE,
  setup = TRUE
)
}
\arguments{
\item{env}{environment containing the matrices defining the LP
problem.}

\item{g0}{set of expectations for each terms of the MTR for the
control group.}

\item{g1}{set of expectations for each terms of the MTR for the
control group.}

\item{criterion.tol}{non-negative scalar, determines how much the
quadratic constraint should be relaxed by. If set to 0, the
constraint is not relaxed at all.}

\item{criterion.min}{minimum of (SSR - SSY) of a linear regression
with shape constraints.}

\item{rescale}{boolean, set to \code{TRUE} if the MTR components
should be rescaled to improve stability in the LP/QP/QCP
optimization.}

\item{setup}{boolean, set to \code{TRUE} if the QP problem should
be set up for solving the bounds, which includes the quadratic
constraint. Set to \code{FALSE} if the quadratic constraint
should be removed.}
}
\value{
A list of matrices and vectors necessary to define an LP
    problem for Gurobi or MOSEK.
}
\description{
This function is only used when the direct MTR regression procedure
is used. This function simply constructs the quadratic constraint,
and adds it to the LP problem defined by the linear optimization problem
for the bounds and the linear shape constraints.
}
