% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audit.R
\name{audit}
\alias{audit}
\title{Audit procedure}
\usage{
audit(
  data,
  uname,
  m0,
  m1,
  pm0,
  pm1,
  splinesobj,
  vars_mtr,
  terms_mtr0,
  terms_mtr1,
  vars_data,
  initgrid.nu = 20,
  initgrid.nx = 20,
  audit.nx = 2500,
  audit.nu = 25,
  audit.add = 100,
  audit.max = 25,
  audit.tol,
  audit.grid = NULL,
  m1.ub,
  m0.ub,
  m1.lb,
  m0.lb,
  mte.ub,
  mte.lb,
  m1.ub.default = FALSE,
  m0.ub.default = FALSE,
  mte.ub.default = FALSE,
  m1.lb.default = FALSE,
  m0.lb.default = FALSE,
  mte.lb.default = FALSE,
  m0.dec = FALSE,
  m0.inc = FALSE,
  m1.dec = FALSE,
  m1.inc = FALSE,
  mte.dec = FALSE,
  mte.inc = FALSE,
  equal.coef0,
  equal.coef1,
  sset,
  gstar0,
  gstar1,
  orig.sset = NULL,
  orig.criterion = NULL,
  criterion.tol = 1e-04,
  solver,
  solver.options,
  solver.presolve,
  solver.options.criterion,
  solver.options.bounds,
  rescale = TRUE,
  smallreturnlist = FALSE,
  noisy = TRUE,
  debug = FALSE
)
}
\arguments{
\item{data}{\code{data.frame} or \code{data.table} used to estimate
the treatment effects.}

\item{uname}{variable name for the unobservable used in declaring
the MTRs. The name can be provided with or without quotation
marks.}

\item{m0}{one-sided formula for the marginal treatment response
function for the control group. Splines may also be
incorporated using the expression \code{uSpline}, e.g.
\code{uSpline(degree = 2, knots = c(0.4, 0.8), intercept =
TRUE)}. The \code{intercept} argument may be omitted, and is
set to \code{TRUE} by default.}

\item{m1}{one-sided formula for the marginal treatment response
function for the treated group. See \code{m0} for details.}

\item{pm0}{A list of the monomials in the MTR for the control
group.}

\item{pm1}{A list of the monomials in the MTR for the treated
group.}

\item{splinesobj}{list of spline components in the MTRs for treated
and control groups. Spline terms are extracted using
\code{\link{removeSplines}}. This object is supposed to be a
dictionary of splines, containing the original calls of each
spline in the MTRs, their specifications, and the index used
for naming each basis spline.}

\item{vars_mtr}{character, vector of variables entering into
\code{m0} and \code{m1}.}

\item{terms_mtr0}{character, vector of terms entering into
\code{m0}.}

\item{terms_mtr1}{character, vector of terms entering into
\code{m1}.}

\item{vars_data}{character, vector of variables that can be found
in the data.}

\item{initgrid.nu}{integer determining the number of points in the
open interval (0, 1) drawn from a Halton sequence. The end
points 0 and 1 are additionally included. These points are
always a subset of the points defining the audit grid (see
\code{audit.nu}). These points are used to form the initial
constraint grid for imposing shape restrictions on the \code{u}
components of the MTRs.}

\item{initgrid.nx}{integer determining the number of points of the
covariates used to form the initial constraint grid for
imposing shape restrictions on the MTRs.}

\item{audit.nx}{integer determining the number of points on the
covariates space to audit in each iteration of the audit
procedure.}

\item{audit.nu}{integer determining the number of points in the
open interval (0, 1) drawn from a Halton sequence. The end
points 0 and 1 are additionally included. These points are used
to audit whether the shape restrictions on the \code{u}
components of the MTRs are satisfied. The initial grid used to
impose the shape constraints in the LP/QCQP problem are
constructed from a subset of these points.}

\item{audit.add}{maximum number of points to add to the initial
constraint grid for imposing each kind of shape constraint. For
example, if there are 5 different kinds of shape constraints,
there can be at most \code{audit.add * 5} additional points
added to the constraint grid.}

\item{audit.max}{maximum number of iterations in the audit
procedure.}

\item{audit.tol}{feasibility tolerance when performing the
audit. By default to set to be 1e-06, which is equal to the
default feasibility tolerances of Gurobi (\code{solver =
"gurobi"}), CPLEX (\code{solver = "cplexapi"}), and Rmosek
(\code{solver = "rmosek"}). This parameter should only be
changed if the feasibility tolerance of the solver is changed,
or if numerical issues result in discrepancies between the
solver's feasibility check and the audit.}

\item{audit.grid}{list, contains the \code{A} matrix used in the
audit for the original sample, as well as the RHS vector used
in the audit from the original sample.}

\item{m1.ub}{numeric value for upper bound on MTR for the treated
group. By default, this will be set to the largest value of the
observed outcome in the estimation sample.}

\item{m0.ub}{numeric value for upper bound on MTR for the control
group. By default, this will be set to the largest value of the
observed outcome in the estimation sample.}

\item{m1.lb}{numeric value for lower bound on MTR for the treated
group. By default, this will be set to the smallest value of
the observed outcome in the estimation sample.}

\item{m0.lb}{numeric value for lower bound on MTR for the control
group. By default, this will be set to the smallest value of
the observed outcome in the estimation sample.}

\item{mte.ub}{numeric value for upper bound on treatment effect
parameter of interest.}

\item{mte.lb}{numeric value for lower bound on treatment effect
parameter of interest.}

\item{m1.ub.default}{boolean, default set to FALSE. Indicator for
whether the value assigned was by the user, or set by default.}

\item{m0.ub.default}{boolean, default set to FALSE. Indicator for
whether the value assigned was by the user, or set by default.}

\item{mte.ub.default}{boolean, default set to FALSE. Indicator for
whether the value assigned was by the user, or set by default.}

\item{m1.lb.default}{boolean, default set to FALSE. Indicator for
whether the value assigned was by the user, or set by default.}

\item{m0.lb.default}{boolean, default set to FALSE. Indicator for
whether the value assigned was by the user, or set by default.}

\item{mte.lb.default}{boolean, default set to FALSE. Indicator for
whether the value assigned was by the user, or set by default.}

\item{m0.dec}{logical, set to \code{FALSE} by default. Set equal to
\code{TRUE} if the MTR for the control group should be weakly
monotone decreasing.}

\item{m0.inc}{logical, set to \code{FALSE} by default. Set equal to
\code{TRUE} if the MTR for the control group should be weakly
monotone increasing.}

\item{m1.dec}{logical, set to \code{FALSE} by default. Set equal to
\code{TRUE} if the MTR for the treated group should be weakly
monotone decreasing.}

\item{m1.inc}{logical, set to \code{FALSE} by default. Set equal to
\code{TRUE} if the MTR for the treated group should be weakly
monotone increasing.}

\item{mte.dec}{logical, set to \code{FALSE} by default. Set equal
to \code{TRUE} if the MTE should be weakly monotone decreasing.}

\item{mte.inc}{logical, set to \code{FALSE} by default. Set equal
to \code{TRUE} if the MTE should be weakly monotone increasing.}

\item{equal.coef0}{character, a vector containing all the terms in
\code{m0} that should have the same coefficients in
\code{m1}. The order of the variables must match those of
\code{equal.coef1}, which contains all the corresponding terms
in \code{m1}. The reason the terms are entered separately for
\code{m0} and \code{m1} is because the spline terms may be
named differently across treatment and control groups.}

\item{equal.coef1}{character, a vector containing all the terms in
\code{m1} that should have the same coefficients in
\code{m0}. See the description for \code{equal.coef0} for more
details.}

\item{sset}{a list containing the point estimates and gamma moments
for each IV-like specification.}

\item{gstar0}{set of expectations for each terms of the MTR for the
control group, corresponding to the target parameter.}

\item{gstar1}{set of expectations for each terms of the MTR for the
control group, corresponding to the target parameter.}

\item{orig.sset}{list, only used for bootstraps. The list contains
the gamma moments for each element in the S-set, as well as the
IV-like coefficients.}

\item{orig.criterion}{numeric, only used for bootstraps. The scalar
corresponds to the minimum observational equivalence criterion
from the original sample.}

\item{criterion.tol}{tolerance for the criterion function, and is
set to 1e-4 by default. The criterion measures how well the
IV-like moments/conditional means are matched using the
l1-norm. Statistical noise may prohibit the theoretical LP/QCQP
problem from being feasible. That is, there may not exist a set
of MTR coefficients that are able to match all the specified
moments. The function thus first estimates the minimum
criterion, which is reported in the output under the name
'minimum criterion', with a criterion of 0 meaning that all
moments were able to be matched. The function then relaxes the
constraints by tolerating a criterion up to \code{minimum
criterion * (1 + criterion.tol)}. Set \code{criterion.tol} to a
value greater than 0 to allow for more conservative bounds.}

\item{solver}{character, name of the programming package in R used
to obtain the bounds on the treatment effect. The function
supports \code{'gurobi'}, \code{'cplexapi'}, \code{rmosek},
\code{'lpsolveapi'}. The name of the solver should be provided
with quotation marks.}

\item{solver.options}{list, each item of the list should correspond
to an option specific to the solver selected.}

\item{solver.presolve}{boolean, default set to \code{TRUE}. Set
this parameter to \code{FALSE} if presolve should be turned off
for the LP/QCQP problems.}

\item{solver.options.criterion}{list, each item of the list should
correspond to an option specific to the solver selected. These
options are specific for finding the minimum criterion.}

\item{solver.options.bounds}{list, each item of the list should
correspond to an option specific to the solver selected. These
options are specific for finding the bounds.}

\item{rescale}{boolean, set to \code{TRUE} if the MTR components
should be rescaled to improve stability in the LP/QCQP
optimization.}

\item{smallreturnlist}{boolean, default set to \code{FALSE}. Set to
\code{TRUE} to exclude large intermediary components
(i.e. propensity score model, LP/QCQP model, bootstrap
iterations) from being included in the return list.}

\item{noisy}{boolean, default set to \code{TRUE}. If \code{TRUE},
then messages are provided throughout the estimation
procedure. Set to \code{FALSE} to suppress all messages,
e.g. when performing the bootstrap.}

\item{debug}{boolean, indicates whether or not the function should
provide output when obtaining bounds. The option is only
applied when \code{solver = 'gurobi'} or \code{solver =
'rmosek'}. The output provided is the same as what the Gurobi
API would send to the console.}
}
\value{
a list. Included in the list are estimates of the treatment
    effect bounds; the minimum violation of observational
    equivalence of the set of IV-like estimands; the list of
    matrices and vectors defining the LP/QCQP problem; the points used
    to generate the audit grid, and the points where the shape
    constraints were violated.
}
\description{
This is the wrapper for running the entire audit procedure. This
function sets up the LP/QCQP problem of minimizing criterion.  for
the set of IV-like estimands, while satisfying boundedness and
monotonicity constraints declared by the user. Rather than enforce
that boundedness and monotonicity hold across the entire support of
covariates and unobservables, this procedure enforces the
conditions over a grid of points. This grid corresponds to the set
of values the covariates can take, and a set of values of the
unobservable term. The size of this grid is specified by the user
in the function arguments. The procedure first estimates the bounds
while imposing the shape constraints for an initial subset of
points in the grid. The procedure then goes on to check ('audit')
whether the constraints are satisfied over the entire grid. Any
point where either the boundedness or monotonicity constraints are
violated are incorporated into the initial grid, and the process is
repeated until the audit no longer finds any violations, or until
some maximum number of iterations is reached.
}
\examples{
dtm <- ivmte:::gendistMosquito()

## Declare empty list to be updated (in the event multiple IV like
## specifications are provided
sSet <- list()

## Declare MTR formulas
formula0 = ~ 1 + u
formula1 = ~ 1 + u

## Construct object that separates out non-spline components of MTR
## formulas from the spline components. The MTR functions are
## obtained from this object by the function 'genSSet'
splinesList = list(removeSplines(formula0), removeSplines(formula1))

## If splines are interacted with other variables, the
## 'interactSplines' should be used.
## splinesList <- interactSplines(splinesobj = splinesList,
##                               m0 = formula0,
##                               m1 = formula1,
##                               data = data,
##                               uname = 'u')

## Construct MTR polynomials
polynomials0 <- polyparse(formula = formula0,
                 data = dtm,
                 uname = u,
                 as.function = FALSE)

polynomials1 <- polyparse(formula = formula1,
                 data = dtm,
                 uname = u,
                 as.function = FALSE)

## Generate propensity score model
propensityObj <- propensity(formula = d ~ z,
                            data = dtm,
                            link = "linear")

## Generate IV estimates
ivEstimates <- ivEstimate(formula = ey ~ d | z,
                          data = dtm,
                          components = l(intercept, d),
                          treat = d,
                          list = FALSE)

## Generate target gamma moments
targetGamma <- genTarget(treat = "d",
                         m0 = ~ 1 + u,
                         m1 = ~ 1 + u,
                         target = "atu",
                         data = dtm,
                         splinesobj = splinesList,
                         pmodobj = propensityObj,
                         pm0 = polynomials0,
                         pm1 = polynomials1)

## Construct S-set, which contains the coefficients and weights
## corresponding to various IV-like estimands
sSet <- genSSet(data = dtm,
                sset = sSet,
                sest = ivEstimates,
                splinesobj = splinesList,
                pmodobj = propensityObj$phat,
                pm0 = polynomials0,
                pm1 = polynomials1,
                ncomponents = 2,
                scount = 1,
                yvar = "ey",
                dvar = "d",
                means = TRUE)

## Perform audit procedure and return bounds
audit(data = dtm,
      uname = u,
      m0 = formula0,
      m1 = formula1,
      pm0 = polynomials0,
      pm1 = polynomials1,
      splinesobj = splinesList,
      vars_data = colnames(dtm),
      vars_mtr = "u",
      terms_mtr0 = "u",
      terms_mtr1 = "u",
      sset = sSet$sset,
      gstar0 = targetGamma$gstar0,
      gstar1 = targetGamma$gstar1,
      m0.inc = TRUE,
      m1.dec = TRUE,
      m0.lb = 0.2,
      m1.ub = 0.8,
      audit.max = 5,
      solver = "lpSolveAPI")

}
