% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{ovb_contour_plot}
\alias{ovb_contour_plot}
\alias{ovb_contour_plot.iv_fit}
\title{Contour plots of omitted variable bias for IV}
\usage{
ovb_contour_plot(...)

\method{ovb_contour_plot}{iv_fit}(
  model,
  benchmark_covariates = NULL,
  kz = 1,
  ky = kz,
  kd = kz,
  sensitivity.of = c("lwr", "upr", "t-value"),
  parm = "iv",
  r2zw.x = NULL,
  r2y0w.zx = r2zw.x,
  bound_label = "manual bound",
  xlab = NULL,
  ylab = NULL,
  ...
)
}
\arguments{
\item{...}{further arguments and graphical parameters.}

\item{model}{a model created with the function \code{\link{iv_fit}}.}

\item{benchmark_covariates}{character vector of the names of covariates that will be used to bound the plausible strength of the latent variables.}

\item{kz}{numeric vector. Parameterizes how many times stronger the latent variables are related to the instrument in comparison to the observed benchmark covariates.
Default value is \code{1} (latent variable is as strong as benchmark covariate).}

\item{ky}{numeric vector. Parameterizes how many times stronger the latent variables are related to the (pot.) outcome in comparison to the observed benchmark covariates.}

\item{kd}{numeric vector. Parameterizes how many times stronger the latent variables are related to the treatment in comparison to the observed benchmark covariates. Default value is the same as \code{kz}.}

\item{sensitivity.of}{should the contour plot show adjusted lower limits of confidence intervals (\code{"lwr"}), upper limit of confidence intervals (\code{"upr"}) or t-values (\code{"t-value"})?}

\item{parm}{contour plots of which estimate? Options are \code{iv} for instrumental variable estimates, \code{fs} for first-stage estimates, and \code{rf} for reduced-form estimates.}

\item{r2zw.x}{(optional) hypothetical partial R2 of latent variables
W with the instrument Z, given observed covariates X.}

\item{r2y0w.zx}{(optional) hypothetical partial R2 of latent variables W with the (pot.) outcome Y(0) given Z and X. Default is the same as \code{r2zw.x}.}

\item{bound_label}{label to bounds provided manually in \code{r2zw.x} and \code{r2y0w.zx}.}

\item{xlab}{label of x axis. If `NULL`, default label is used.}

\item{ylab}{label of y axis. If `NULL`, default label is used.}
}
\value{
The function is called for its side effect of producing a contour plot.
It invisibly returns a \code{list} with the grid values used for the contour plot.
}
\description{
Contour plots of omitted variable bias for sensitivity analysis of instrumental variable estimates.

The main inputs are an \code{\link{iv_fit}} model, and the covariates used for benchmarking the strength of omitted variables.

If \code{parm = "iv"} (default) contour plots of the IV estimate are shown. The horizontal axis of the plot shows hypothetical values of the partial R2 of latent variables with the instrument. The vertical axis shows hypothetical values of the partial R2 of latent variables with the (pot.) outcome. The contour levels represent the adjusted lower limit (or upper limit) of the Anderson-Rubin confidence interval of the IV estimate, or the t-value for testing a specific null hypothesis.  The reference points are the bounds on the partial R2 of latent variables if they were k times "as strong" as the observed covariate used for benchmarking (see arguments kz and ky). The dotted red line show the chosen critical threshold (for instance, zero): latent variables with such strength (or stronger) are sufficient to invalidate the research conclusions.

if \code{parm = "fs"} or \code{parm = "rf"}, then contour plots of the first-stage and reduced-form regression are shown. See, e.g, \code{\link[sensemakr]{ovb_contour_plot.lm}}.

See Cinelli and Hazlett (2020, 2025) for details.
}
\details{
Other parameters include:
\describe{
 \item{\code{alpha}}{significance level.}
 \item{\code{threshold}}{ critical threshold, default is \code{0}.}
 \item{\code{lim}}{limits for the axes.}
 \item{\code{lim.x}}{limits for the x axis. Default is \code{lim}.}
 \item{\code{lim.y}}{limits for the y axis. Default is \code{lim}.}
 \item{\code{nlevels}}{number of levels in the contour plot.}
 \item{\code{col.contour}}{color of the contour lines.}
 \item{\code{col.thr.line}}{color of the threshold line.}
 \item{\code{label.text}}{should benchmark label texts be shown? Default is \code{TRUE}.}
 \item{\code{cex.label.text}}{character size of label text. Default is \code{.7}.}
 \item{\code{label.bump.x}}{bump on the x coordinate of label text.}
 \item{\code{label.bump.y}}{bump on the y coordinate of label text.}
 \item{\code{cex.lab}}{The magnification to be used for x and y labels relative to the current setting of cex.}
 \item{\code{cex.main}}{The magnification to be used for main titles relative to the current setting of cex.}
 \item{\code{cex.axis}}{The magnification to be used for axis annotation relative to the current setting of cex.}
 \item{\code{asp}}{the y/x aspect ratio. Default is 1.}
}
If \code{parm = "fs"} or \code{parm = "rf"} the function is simply a wrapper to the sensemakr function \code{\link[sensemakr]{ovb_contour_plot.lm}} on the first-stage or reduced-form \code{\link{lm}} models.
}
\examples{
data("card")
y <- card$lwage
d <- card$educ
z <- card$nearc4
x <- model.matrix( ~ exper + expersq + black + south + smsa + reg661 + reg662 +
                     reg663 + reg664 + reg665+ reg666 + reg667 + reg668 + smsa66,
                   data = card)
card.fit <- iv_fit(y, d, z, x)

# contour plot of the lower CI limit
ovb_contour_plot(card.fit, sensitivity.of = "lwr",
                 benchmark_covariates = "black")
}
\references{
Cinelli, C. and Hazlett, C. (2020), "Making Sense of Sensitivity: Extending Omitted Variable Bias." Journal of the Royal Statistical Society, Series B (Statistical Methodology).

Cinelli, C. and Hazlett, C. (2025), "An Omitted Variable Bias Framework for Sensitivity Analysis of Instrumental Variables." Biometrika. \doi{10.1093/biomet/asaf004}
}
