% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_optsamplesize_wHolmpm.R
\name{optsamplesize_wHolmpm}
\alias{optsamplesize_wHolmpm}
\title{Compute the optimal sample size for the weighted Holm procedure with allowance for different data maturities}
\usage{
optsamplesize_wHolmpm(
  alpha,
  betavec,
  deltavec,
  rho,
  maturity,
  ninterval = c(2, 2000),
  alphalist = seq(from = 0, to = alpha, by = 0.005)
)
}
\arguments{
\item{alpha}{the significance level}

\item{betavec}{a numeric vector of two values, including one minus the desired power for rejecting H1 and one minus the desired power for rejecting H2}

\item{deltavec}{a numeric vector of two values representing the effect sizes for the two hypotheses}

\item{rho}{the correlation coefficient between two test statistics}

\item{maturity}{a numeric vector of two values representing the data maturities for the two hypotheses}

\item{ninterval}{a vector containing the end-points of the interval to be searched for optimal sample size}

\item{alphalist}{a vector of discrete alpha values}
}
\value{
the overall optimal sample size for the weighted Holm procedure with allowance for different data maturities
}
\description{
Compute the optimal sample size for the weighted Holm procedure with allowance for different data maturities
}
\examples{
rrr <- 2
alpha <- 0.025
k <- 0.6761
ninterval <- c(2, 1000)
betavec <- c(0.05, 0.15)
rho <- 0.4
maturity <- c(0.65, 0.70)
psivec <- c(0.67, 0.73)
thetavec <- log(psivec)
deltavec <- (-thetavec)*sqrt(rrr)/(1+rrr)
result <- optsamplesize_wHolmpm(alpha = alpha, betavec = betavec,
deltavec = deltavec , rho = rho,
maturity = maturity, ninterval = ninterval)
result$nopt
}
\references{
Gou, J., Chang, Y., Li, T., and Zhang, F. (2025). Improved trimmed weighted Hochberg procedures with two endpoints and sample size optimization. Technical Report.
}
\author{
Jiangtao Gou

Fengqing Zhang
}
