% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iteror_array.R, R/iteror_data_frame.R
\name{iteror.array}
\alias{iteror.array}
\alias{iteror.matrix}
\alias{iteror.data.frame}
\title{Iterate over an array or data frame by a specified dimension.}
\usage{
\method{iteror}{array}(
  obj,
  ...,
  by = c("cell", "row", "column"),
  chunkSize,
  chunks,
  recycle = FALSE,
  drop = FALSE,
  rowMajor = TRUE
)

\method{iteror}{matrix}(
  obj,
  ...,
  by = c("cell", "row", "column"),
  chunkSize,
  chunks,
  recycle = FALSE,
  drop = FALSE,
  rowMajor = TRUE
)

\method{iteror}{data.frame}(obj, ..., recycle = FALSE, chunkSize, chunks, by = c("column", "row"))
}
\arguments{
\item{obj}{An object to iterate over.}

\item{...}{Undocumented.}

\item{by}{Which dimension to slice an array or data frame by. Can be "cell",
"row", "column", or numeric dimensions.}

\item{chunkSize}{The thickness of the slice to take along the specified dimension.}

\item{chunks}{How many slices to take.}

\item{recycle}{If TRUE, the iteror starts over on reaching the end.}

\item{drop}{Whether to drop the array dimensions enumerated over.}

\item{rowMajor}{If TRUE, will return slices in order with the first
indices varying fastest (same as in \link{i_enumerate}).}
}
\value{
an iteror yielding from \code{obj} along the specified dimensions.
}
\description{
Iterate over an array or data frame by a specified dimension.
}
\examples{
l <- iteror(letters, chunkSize=7)
as.list(l)

a <- array(1:8, c(2, 2, 2))

# iterate over all the slices
it <- iteror(a, by=3)
as.list(it)

# iterate over all the columns of each slice
it <- iteror(a, by=c(2, 3))
as.list(it)

# iterate over all the rows of each slice
it <- iteror(a, by=c(1, 3))
as.list(it)

}
