% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipermutations.R
\name{i_permutations}
\alias{i_permutations}
\alias{ipermutations}
\title{Iterator that generates all permutations of a vector.}
\usage{
i_permutations(object, m = NULL)
}
\arguments{
\item{object}{vector}

\item{m}{length of permutations. By default, full-length permutations are
generated.}
}
\value{
iterator that generates all permutations of \code{object}
}
\description{
Constructs an iterator generates all permutations of an iterable object. By
default, full-length permutations are generated. If \code{m} is specified,
successive \code{m} length permutations are instead generated.
}
\details{
The implementation is loosely based on that of Python's itertools.
}
\examples{
it <- ipermutations(1:3)

nextOr(it, NA) # c(1, 2, 3)
nextOr(it, NA) # c(1, 3, 2)
nextOr(it, NA) # c(3, 1, 2)
nextOr(it, NA) # c(3, 2, 1)
nextOr(it, NA) # c(2, 3, 1)
nextOr(it, NA) # c(2, 1, 3)

it2 <- ipermutations(letters[1:4])
# 24 = 4! permutations of the letters a, b, c, and d
as.list(it2)

}
