% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_grid.R
\docType{methods}
\name{ternary_grid}
\alias{ternary_grid}
\title{Add Grid to a Ternary Plot}
\usage{
ternary_grid(
  primary = NULL,
  secondary = NULL,
  center = getOption("isopleuros.center"),
  scale = getOption("isopleuros.scale"),
  col.primary = "darkgray",
  col.secondary = "lightgray",
  lty.primary = "dashed",
  lty.secondary = "dotted",
  lwd.primary = 1,
  lwd.secondary = lwd.primary
)
}
\arguments{
\item{primary}{An \code{\link{integer}} specifying the number of cells of the primary
grid in \code{x}, \code{y} and \code{z} direction.}

\item{secondary}{An \code{\link{integer}} specifying the number of cells of the
secondary grid in \code{x}, \code{y} and \code{z} direction.}

\item{center}{A \code{\link{numeric}} vector giving the center. If \code{NULL}
(the default), data are assumed not centered.}

\item{scale}{A \code{\link{numeric}} vector giving the scale factor. If \code{NULL}
(the default), data are assumed not scaled.}

\item{col.primary, col.secondary}{A \code{\link{character}} string specifying the color
of the grid lines.}

\item{lty.primary, lty.secondary}{A \code{\link{character}} string or \code{\link{numeric}}
value specifying the line type of the grid lines.}

\item{lwd.primary, lwd.secondary}{A non-negative \code{\link{numeric}} value specifying
the line width of the grid lines.}
}
\value{
\code{ternary_grid()} is called it for its side-effects.
}
\description{
Adds a triangular grid to an existing plot.
}
\examples{
## Data from Aitchison 1986
ternary_plot(lava, center = FALSE, scale = FALSE, col = "red", pch = 16)
ternary_grid(5)

## Center
z <- ternary_plot(lava, center = TRUE, col = "blue", pch = 16)
ternary_grid(5, center = z$center)

## Center and scale
z <- ternary_plot(lava, center = TRUE, scale = TRUE, col = "green", pch = 16)
ternary_grid(5, center = z$center, scale = z$scale)
}
\seealso{
Other graphical elements: 
\code{\link{ternary_axis}()},
\code{\link{ternary_box}()},
\code{\link{ternary_pairs}()},
\code{\link{ternary_plot}()},
\code{\link{ternary_title}()}
}
\author{
N. Frerebeau
}
\concept{graphical elements}
