#' Arctic Lake Sediments Compositions
#'
#' Sand, silt, clay compositions of 39 sediment samples at different water
#' depths in an Arctic lake.
#' @format A [`data.frame`] with 4 variables:
#'  \describe{
#'    \item{sand}{}
#'    \item{silt}{}
#'    \item{clay}{}
#'    \item{depth}{Water depth (m).}
#'  }
#' @source
#'  Aitchison, J. (1986). *The Statistical Analysis of Compositional Data*.
#'  London: Chapman and Hall. \doi{10.1007/978-94-009-4109-0}.
#' @family datasets
#' @keywords datasets
"arctic"

#' Boxite Compositions
#'
#' Compositions of 25 specimens of boxite.
#' @format A [`data.frame`] with 5 variables:
#'  \describe{
#'    \item{A}{albite.}
#'    \item{B}{blandite.}
#'    \item{C}{cornite.}
#'    \item{D}{daubite.}
#'    \item{E}{endite.}
#'  }
#' @source
#'  Aitchison, J. (1986). *The Statistical Analysis of Compositional Data*.
#'  London: Chapman and Hall. \doi{10.1007/978-94-009-4109-0}.
#' @family datasets
#' @keywords datasets
"boxite"

#' Skye Lavas Compositions
#'
#' AFM compositions of 23 aphyric Skye lavas.
#' @format A [`data.frame`] with 3 variables:
#'  \describe{
#'    \item{A}{Na2O + K2O (percent).}
#'    \item{F}{Fe2O3 (percent).}
#'    \item{M}{MgO (percent).}
#'  }
#' @source
#'  Aitchison, J. (1986). *The Statistical Analysis of Compositional Data*.
#'  London: Chapman and Hall. \doi{10.1007/978-94-009-4109-0}.
#' @family datasets
#' @keywords datasets
"lava"
