% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{orbi_define_basepeak}
\alias{orbi_define_basepeak}
\title{Define the denominator for ratio calculation}
\usage{
orbi_define_basepeak(dataset, basepeak_def)
}
\arguments{
\item{dataset}{An aggregated dataset or a data frame of peaks (i.e. works directly after \code{\link[=orbi_identify_isotopocules]{orbi_identify_isotopocules()}} as well as with a tibble from \link[=orbi_get_data]{orbi_get_data(peaks = everything())} or when reading from an IsoX file)}

\item{basepeak_def}{The isotopocule that gets defined as base peak, i.e. the denominator to calculate ratios}
}
\value{
same object as provided in \code{dataset} without the rows of the basepeak isotopocule and instead three new columns called \code{basepeak}, \code{basepeak_ions}, and \code{ratio} holding the basepeak information and the isotope ratios vs. the base peak
}
\description{
\code{orbi_define_basepeak()} sets one isotopocule in the data frame as the base peak (ratio denominator) and calculates the instantaneous isotope ratios against it.
}
\examples{
fpath <- system.file("extdata", "testfile_flow.isox", package = "isoorbi")
df <- orbi_read_isox(file = fpath) |>
  orbi_simplify_isox() |>
  orbi_define_basepeak(basepeak_def = "M0")

}
