% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_isobxr_master.R
\name{read.isobxr_master}
\alias{read.isobxr_master}
\title{Read and inspect isobxr master files}
\usage{
read.isobxr_master(
  workdir,
  isobxr_master_file = "0_ISOBXR_MASTER",
  inspect = TRUE,
  export_rds = FALSE
)
}
\arguments{
\item{workdir}{Working directory of \strong{\emph{isobxr excel master file}}
and where output files will be stored if exported by user.
(character string)}

\item{isobxr_master_file}{Name of \strong{\emph{isobxr excel master file}}.
(without file "xlsx" extension).
Default is "0_ISOBXR_MASTER".}

\item{inspect}{If TRUE, checks all inputs from isobxr master file for format
and structure errors. \cr
Default is TRUE.}

\item{export_rds}{If TRUE, exports rds version of isobxr master file
to working directory. \cr
Default is FALSE.}
}
\value{
A formatted list of data frames containing constants, box, fluxes and
fractionation coefficients descriptions.
}
\description{
A function to read and inspect the isobxr master files
and obtain a master formatted list.
}
\examples{
read.isobxr_master(workdir = "/Users/username/Documents/1_ABC_tutorial",
                   isobxr_master_file = "0_ISOBXR_MASTER",
                   export_rds = FALSE,
                   inspect = TRUE)

}
