% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_relaxation.R
\name{plot_relaxation}
\alias{plot_relaxation}
\title{plot relaxation}
\usage{
plot_relaxation(
  workdir,
  flux_list,
  coeff_list,
  spiked_boxes,
  spike.max_delta = 100,
  n_steps = 10000,
  hidden_boxes = NULL,
  show.residence_time = TRUE,
  show.facets = FALSE,
  time_landmarks = NULL,
  time_as_log10 = TRUE,
  isobxr_master_file = "0_ISOBXR_MASTER",
  time.resolution_cut = NULL
)
}
\arguments{
\item{workdir}{Working directory of \strong{\emph{isobxr excel master file}}
and where output files will be stored if exported by user.
(character string)}

\item{flux_list}{Name of the list of fluxes and initial box sizes to be used for the run, \cr
calling (by its header name) a single column of the \strong{FLUXES} sheet
of the \strong{\emph{isobxr excel master file}}. \cr
(character string)}

\item{coeff_list}{Name of the list of fractionation coefficients to be used for the run, \cr
calling (by its header name) a single column of the \strong{COEFFS} sheet
of the \strong{\emph{isobxr excel master file}}. \cr
(character string)}

\item{spiked_boxes}{Vector of box names ("BOX_ID") to be spiked. \cr
If several boxes are listed, initial spike will be evenly distributed from 0 to spike.max_delta value.}

\item{spike.max_delta}{Value of the maximum spike isotope composition \cr
(in permil on the delta scale). \cr
Default is 100 permil.}

\item{n_steps}{Number of calculation steps. Determines the resolution of the run. \cr
Default is 10000.}

\item{hidden_boxes}{Vector of boxes to hide from plots. \cr
For instance c("SOURCE", "SINK"). \cr
Default is NULL.}

\item{show.residence_time}{If TRUE, displays box-specific residence times on plot. \cr
Default is FALSE.}

\item{show.facets}{If TRUE, displays results in box-specific facets. \cr
Default is FALSE.}

\item{time_landmarks}{Vector of time landmarks to display on x-axis (numerical values).}

\item{time_as_log10}{If TRUE, uses logarithmic time scale in plot. \cr
Default is TRUE.}

\item{isobxr_master_file}{Name of \strong{\emph{isobxr excel master file}}. \cr
Default is "0_ISOBXR_MASTER".}

\item{time.resolution_cut}{Time below which resolution is increased. Default is NULL.}
}
\value{
A plots showing the evolution of the isotopic ratios in the system until full relaxation, \cr
defined as the maximum relaxation time multiplied by 10.
}
\description{
A function to plot the relaxation of isotope ratios in a system,
including characteristic times
}
\examples{
\dontrun{
plot_relaxation(workdir = "/Users/username/Documents/1_ABC_tutorial",
                flux_list = "Fx6_ABC_open_bal",
                coeff_list = "a0",
                n_steps = 1000,
                spiked_boxes = c("SOURCE"))
}
}
