% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_df.R
\name{shape_df}
\alias{shape_df}
\title{Create a Data Frame of Item Metadata}
\usage{
shape_df(
  par.drm = list(a = NULL, b = NULL, g = NULL),
  par.prm = list(a = NULL, d = NULL),
  item.id = NULL,
  cats,
  model,
  default.par = FALSE
)
}
\arguments{
\item{par.drm}{A list containing three numeric vectors for dichotomous item
parameters: item discrimination (\code{a}), item difficulty (\code{b}), and guessing
parameters (\code{g}).}

\item{par.prm}{A list containing polytomous item parameters. The list must
include a numeric vector \code{a} for item discrimination (slope) parameters,
and a list \code{d} of numeric vectors specifying difficulty (or threshold)
parameters for each item. See the \strong{Details} section for more information.}

\item{item.id}{A character vector of item IDs. If \code{NULL}, default IDs (e.g.,
"V1", "V2", ...) are assigned automatically.}

\item{cats}{A numeric vector indicating the number of score categories for
each item.}

\item{model}{A character vector specifying the IRT model for each item.
Available options are \code{"1PLM"}, \code{"2PLM"}, \code{"3PLM"}, and \code{"DRM"} for
dichotomous items, and \code{"GRM"} and \code{"GPCM"} for polytomous items. The label
\code{"DRM"} serves as a general category that encompasses all dichotomous
models (\code{"1PLM"}, \code{"2PLM"}, and \code{"3PLM"}), while \code{"GRM"} and \code{"GPCM"} refer
to the graded response model and (generalized) partial credit model,
respectively.}

\item{default.par}{Logical. If \code{TRUE}, default item parameters are generated
based on the specified \code{cats} and \code{model}. In this case, the slope
parameter is set to 1, all difficulty (or threshold) parameters are set to
0, and the guessing parameter is set to 0.2 for \code{"3PLM"} or \code{"DRM"} items.
The default is \code{FALSE}.}
}
\value{
A data frame containing item metadata, including item IDs, number of
score categories, IRT model types, and associated item parameters. This
data frame can be used as input for other functions in the \pkg{irtQ}
package, such as \code{\link[=est_irt]{est_irt()}} or \code{\link[=simdat]{simdat()}}.
}
\description{
This function creates a data frame of item metadata—including item
parameters, the number of score categories, and IRT model specifications—to
be used in various IRT-related analyses within the \pkg{irtQ} package.
}
\details{
For any item where \code{"1PLM"} or \code{"2PLM"} is specified in \code{model}, the
guessing parameter will be set to \code{NA}. If \code{model} is a vector of length 1,
the specified model will be replicated across all items.

As in the \code{\link[=simdat]{simdat()}} function, when constructing a mixed-format test
form, it is important to specify the \code{cats} argument to reflect the correct
number of score categories for each item, in the exact order that the items
appear. See \code{\link[=simdat]{simdat()}} for further guidance on how to specify \code{cats}.

When specifying item parameters using \code{par.drm} and/or \code{par.prm}, the
internal structure and ordering of elements must be followed.
\itemize{
\item \code{par.drm} should be a list with three components:
\itemize{
\item \code{a}: a numeric vector of slope parameters
\item \code{b}: a numeric vector of difficulty parameters
\item \code{g}: a numeric vector of guessing parameters
}
\item \code{par.prm} should be a list with two components:
\itemize{
\item \code{a}: a numeric vector of slope parameters for polytomous items
\item \code{d}: a list of numeric vectors specifying threshold (or step) parameters
for each polytomous item
}
}

For items following the (generalized) partial credit model (\code{"GPCM"}), the
threshold (or step) parameters are computed as the overall item difficulty
(location) minus the category-specific thresholds. Therefore, for an item
with \code{m} score categories, \code{m - 1} step parameters must be provided, since
the first category threshold is fixed and does not contribute to category
probabilities.
}
\examples{
## A mixed-format test form
## containing five dichotomous items and two polytomous items
# Create a list of dichotomous item parameters
par.drm <- list(
  a = c(1.1, 1.2, 0.9, 1.8, 1.4),
  b = c(0.1, -1.6, -0.2, 1.0, 1.2),
  g = rep(0.2, 5)
)

# Create a list of polytomous item parameters
par.prm <- list(
  a = c(1.4, 0.6),
  d = list(
    c(0.0, -1.9, 1.2),
    c(0.4, -1.1, 1.5, 0.2)
  )
)

# Create a numeric vector indicating the number of score categories for each item
cats <- c(2, 4, 2, 2, 5, 2, 2)

# Create a character vector specifying the IRT model for each item
model <- c("DRM", "GRM", "DRM", "DRM", "GPCM", "DRM", "DRM")

# Generate an item metadata set using the specified parameters
shape_df(par.drm = par.drm, par.prm = par.prm, cats = cats, model = model)

## An empty item metadata frame with five dichotomous items and two polytomous items
# Create a numeric vector indicating the number of score categories for each item
cats <- c(2, 4, 3, 2, 5, 2, 2)

# Create a character vector specifying the IRT model for each item
model <- c("1PLM", "GRM", "GRM", "2PLM", "GPCM", "DRM", "3PLM")

# Generate an item metadata frame with default parameters
shape_df(cats = cats, model = model, default.par = TRUE)

## A single-format test form consisting of five dichotomous items
# Generate the item metadata
shape_df(par.drm = par.drm, cats = rep(2, 5), model = "DRM")

}
\seealso{
\code{\link[=est_irt]{est_irt()}}, \code{\link[=simdat]{simdat()}}, \code{\link[=shape_df_fipc]{shape_df_fipc()}}
}
\author{
Hwanggyu Lim \email{hglim83@gmail.com}
}
