% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_flexmirt.R
\name{run_flexmirt}
\alias{run_flexmirt}
\title{Run flexMIRT from Within R}
\usage{
run_flexmirt(file.syntax, dir.flex = NULL, show.output.on.console = FALSE, ...)
}
\arguments{
\item{file.syntax}{A single string or character vector specifying the path(s)
to one or more flexMIRT syntax files (with extension *.flexmirt) to be
executed. For example: \code{"C:/Users/Data/irtmodel.flexmirt"}.}

\item{dir.flex}{A character string specifying the directory where flexMIRT is
installed. The folder name typically includes "flexMIRT" (e.g.,
"flexMIRT3", "flexMIRT 3.6"). If set to \code{NULL}, the function searches for
flexMIRT in \code{"C:/Program Files"} and uses a default path if found (e.g.,
\code{"C:/Program Files/flexMIRT3"}).}

\item{show.output.on.console}{Logical. If \code{TRUE}, the output of the system
command is printed to the R console. Default is \code{FALSE}. See
\code{\link[base:system]{base::system()}}.}

\item{...}{Additional arguments passed to \code{\link[base:system]{base::system()}}.}
}
\value{
Output files generated by flexMIRT.
}
\description{
This function runs flexMIRT (Cai, 2017) from within R by executing a model
specified in a flexMIRT syntax file (i.e., *.flexmirt). To use this function,
the flexMIRT software must be installed on your system. This interface is
especially useful for conducting simulation studies or automating batch
analyses involving flexMIRT.
}
\details{
When using a version of flexMIRT earlier than 3.6, the directory
specified in \code{dir.flex} must contain the following six files:
\itemize{
\item \code{WinFlexMIRT.exe}
\item \code{FlexMIRT_x64.exe}
\item \code{FlexMIRT_x86.exe}
\item \code{vpg.dll}
\item \code{vpg.licensing.client.dll}
\item \code{vpg.licensing.dll}
}

For flexMIRT version 3.6 or later, the directory must include the following
five files:
\itemize{
\item \code{WinFlexMIRT.exe}
\item \code{vpg.dll}
\item \code{vpg.licensing.client.dll}
\item \code{vpg.licensing.dll}
\item \code{VPGLicenseClientNet.dll}
}
along with a subdirectory named \code{Resources} that contains the
following two files:
\itemize{
\item \code{flexMIRT_x64_AVX.exe}
\item \code{flexMIRT_x86_AVX.exe}
}
}
\examples{
# Examples below will run if the flexMIRT software is installed
# in the default directory "C:/Program Files/flexMIRT3".
# Otherwise, specify the directory where flexMIRT is installed
# using the 'dir.flex' argument.

\dontrun{
# (1) Run a single syntax file
# Load an example flexMIRT syntax file for estimating item parameters using the 2PL model
file.syntax <- system.file("extdata", "2PLM_example.flexmirt", package = "irtQ")

# Run flexMIRT to estimate item parameters for the 2PL model
run_flexmirt(file.syntax = file.syntax, dir.flex = NULL, show.output = TRUE)

# Check the output file
out.file <- system.file("extdata", "2PLM_example-prm.txt", package = "irtQ")
bring.flexmirt(out.file, type = "par")

# (2) Run multiple syntax files
# Load two example flexMIRT syntax files
file.syntax1 <- system.file("extdata", "2PLM_example.flexmirt", package = "irtQ")
file.syntax2 <- system.file("extdata", "3PLM_example.flexmirt", package = "irtQ")

# Run flexMIRT to estimate item parameters for both models
run_flexmirt(file.syntax = c(file.syntax1, file.syntax2), dir.flex = NULL, show.output = FALSE)

# Check the output files
out.file1 <- system.file("extdata", "2PLM_example-prm.txt", package = "irtQ")
out.file2 <- system.file("extdata", "3PLM_example-prm.txt", package = "irtQ")
bring.flexmirt(out.file1, type = "par")
bring.flexmirt(out.file2, type = "par")
}

}
\references{
Cai, L. (2017). flexMIRT 3.5 Flexible multilevel multidimensional
item analysis and test scoring (Computer Software). Chapel Hill, NC: Vector
Psychometric Group.
}
\author{
Hwanggyu Lim \email{hglim83@gmail.com}
}
