% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc2x3.r
\name{icc3.nointer.fn}
\alias{icc3.nointer.fn}
\title{Intraclass Correlation Coefficients ICC(3,1) and ICCa(3,1) under ANOVA Model 3 without interaction.}
\usage{
icc3.nointer.fn(dfra)
}
\arguments{
\item{dfra}{This is a data frame containing 3 columns or more.  The first column contains subject numbers (some duplicates are expected,
as some subject are assumed to have assigned multiple ratings) and each of the remaining columns is associated with a particular rater and
contains its numeric ratings.}
}
\value{
This function returns a list containing the following 11 values:\cr
1. sig2s: the subject variance component.\cr
2. sig2e: the error variance component.\cr
3. icc2r: ICC as a measure of inter-rater relliability.\cr
4. icc2a: ICC as a measure of intra-rater reliability.\cr
5. n: the number of subjects. 6. r: the number of raters.\cr
7. max.rep: the maximum number of ratings per subject.\cr
8. min.rep: the minimum number of ratings per subjects.\cr
9. M: the total number of ratings for all subjects and raters.\cr
10. ov.mean: the overall mean rating.
}
\description{
This function computes 2 Intraclass Correlation Coefficients ICC(3,1) and ICCa(3,1) under the mixed factorial ANOVA model
(Model 3) without any subject-rater interaction. ICC(3,1) is formulated as a measure of inter-rater reliability and ICCa(3,1)
as a measure of intra-rater reliability.
}
\examples{
#iccdata1 is a small dataset that comes with the package. Use it as follows:
library(irrICC)
iccdata1 #see what the iccdata1 dataset looks like
icc3.nointer.fn(iccdata1)
coeff <- icc3.nointer.fn(iccdata1)$icc2r #this only gives you the ICC coefficient
coeff
}
\references{
Gwet, K.L. (2014): \emph{Handbook of Inter-Rater Reliability - 4th ed.} - Equation 10.2.16 of chapter 10,
Advanced Analytics, LLC.
}
