% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simPYY1.R
\name{simPYY1}
\alias{simPYY1}
\title{PFS similarity measure simPYY1}
\usage{
simPYY1(ma, na, mb, nb, k)
}
\arguments{
\item{ma}{PFS membership values for the data set x computed using either triangular or trapezoidal or guassian membership function}

\item{na}{PFS non-membership values for the data set x computed using either Sugeno and Terano's  or Yager's non-membership function}

\item{mb}{PFS membership values for the data set y computed using either triangular or trapezoidal or guassian membership function}

\item{nb}{PFS non-membership values for the data set y computed using either Sugeno and Terano's  or Yager's non-membership function}

\item{k}{A constant value, considered as 1}
}
\value{
The PFS similarity values of data set y with data set x
}
\description{
PFS similarity measure values using simPYY1 computation technique with membership, and non-membership values of two objects or set of objects.
}
\examples{
x<-matrix(c(12,9,14,11,21,16,15,24,20,17,14,11),nrow=4)
y<-matrix(c(11,21,6),nrow=1)
a<-mn(x)
b<-std(x)
a1<-mn(y)
b1<-std(y)
lam<-0.5
ma<-memG(a,b,x)
na<-nonmemS(ma,lam)
mb<-memG(a1,b1,y)
nb<-nonmemS(mb,lam)
k<-1
simPYY1(ma,na,mb,nb,k)
#[1] 0.7253069 0.7257693 0.8985028 0.8985028
}
\references{
X. Peng, H. Yuan, and Y. Yang. Pythagorean fuzzy information measures and their applications. International Journal of Intelligent Systems, 32(10):991 - 1029, 2017.
}
