% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampa.R
\name{sampa}
\alias{sampa}
\alias{xsampa}
\title{Convert phonetic representation from X-SAMPA}
\usage{
sampa(x, to = c("ipa", "arpabet"))

xsampa(x, to = c("ipa", "arpabet"))
}
\arguments{
\item{x}{A phonetic character vector in X-SAMPA}

\item{to}{The phonetic alphabet to convert to.
Defaults to \code{"ipa"}.
\code{"arpa"} and \code{"cmu"} are accepted aliases for \code{"arpabet"}.}
}
\value{
A character vector the same length as \code{x}
}
\description{
Converts to IPA or ARPABET (used by the CMU Pronouncing Dictionary)
}
\examples{
sampa('\%hE"loU')
sampa(c('\%hE"loU', "w3`ld"))

sampa('\%hE"loU', "arpabet")
sampa(c('\%hE"loU', "w3`ld"), "arpabet")
}
\seealso{
\code{\link[=convert_phonetics]{convert_phonetics()}} to convert between any phonetic
representations

\code{\link[=ipa]{ipa()}} to convert from IPA

\code{\link[=arpa]{arpa()}}, \code{\link[=arpabet]{arpabet()}} and \code{\link[=cmu]{cmu()}} to convert from ARPABET (CMU)
}
