% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{utilityBcg}
\alias{utilityBcg}
\title{Brogeden-Cronbach-Gleser Utility Model.}
\usage{
utilityBcg(n = 1, sdy, rxy = NULL, uxs = NULL, sr = NULL, pux = NULL,
  cost = 0, period = 1)
}
\arguments{
\item{n}{The size of the applicant pool}

\item{sdy}{The standard deviation of performance in monetary units.}

\item{rxy}{The correlation between the predictor composite and the criterion.}

\item{uxs}{The average predicter score of those selected. If the uxs is 
unknown, the sr argument can used instead.}

\item{sr}{A selection ratio or a vector of selection ratios.}

\item{pux}{The expected average criterion score of selected applicants}

\item{cost}{The cost per applicant of a selection system.}

\item{period}{The anticipated tenure of selected employees.}
}
\value{
Estimated gain in utility.
}
\description{
Estimates the utility of an employee selection system.
}
\note{
This functions can except either (1) pux, (2) uxs and rxy, or (3) sr and rxy.
}
\examples{
utilityBcg(sdy=10000, rxy=.50, sr=.30)
}
\author{
Allen Goebl and Jeff Jones
}
\references{
Cronbach, L. J., & Gleser, G. C. (1965). \emph{Psychological  
tests and personnel decisions.}, 37-40.
}

